/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.metadata;

import java.util.Objects;
import java.util.Optional;
import org.sonar.db.DbClient;
import org.sonar.server.es.metadata.EsDbCompatibility;
import org.sonar.server.es.metadata.MetadataIndex;
import org.sonar.server.platform.db.migration.history.MigrationHistory;

public class EsDbCompatibilityImpl
implements EsDbCompatibility {
    private final DbClient dbClient;
    private final MetadataIndex metadataIndex;
    private final MigrationHistory dbMigrationHistory;

    public EsDbCompatibilityImpl(DbClient dbClient, MetadataIndex metadataIndex, MigrationHistory dbMigrationHistory) {
        this.dbClient = dbClient;
        this.metadataIndex = metadataIndex;
        this.dbMigrationHistory = dbMigrationHistory;
    }

    @Override
    public boolean hasSameDbVendor() {
        Optional<String> registeredDbVendor = this.metadataIndex.getDbVendor();
        return registeredDbVendor.isPresent() && registeredDbVendor.get().equals(this.getDbVendor());
    }

    @Override
    public boolean hasSameDbSchemaVersion() {
        Optional<Long> registeredVersion = this.metadataIndex.getDbSchemaVersion();
        if (!registeredVersion.isPresent()) {
            return false;
        }
        return this.getDbSchemaVersion().filter(effectiveVersion -> Objects.equals(registeredVersion.get(), effectiveVersion)).isPresent();
    }

    @Override
    public void markAsCompatible() {
        this.metadataIndex.setDbMetadata(this.getDbVendor(), this.getDbSchemaVersion().orElseThrow(() -> new IllegalStateException("DB schema version is not present in database")));
    }

    private String getDbVendor() {
        return this.dbClient.getDatabase().getDialect().getId();
    }

    private Optional<Long> getDbSchemaVersion() {
        return this.dbMigrationHistory.getLastMigrationNumber();
    }
}

