/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.net.HostAndPort;
import io.netty.util.ThreadDeathWatcher;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.reindex.ReindexPlugin;
import org.elasticsearch.join.ParentJoinPlugin;
import org.elasticsearch.percolator.PercolatorPlugin;
import org.elasticsearch.transport.Netty4Plugin;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.process.cluster.NodeType;
import org.sonar.server.es.EsClient;

@ComputeEngineSide
@ServerSide
public class EsClientProvider
extends ProviderAdapter {
    private static final Logger LOGGER = Loggers.get(EsClientProvider.class);
    private EsClient cache;

    public EsClient provide(Configuration config) {
        if (this.cache == null) {
            Settings.Builder esSettings = Settings.builder();
            esSettings.put("cluster.name", (String)config.get("sonar.cluster.name").get());
            boolean clusterEnabled = config.getBoolean("sonar.cluster.enabled").orElse(false);
            boolean searchNode = !clusterEnabled || NodeType.SEARCH.equals((Object)NodeType.parse((String)config.get("sonar.cluster.node.type").orElse(null)));
            MinimalTransportClient nativeClient = new MinimalTransportClient(esSettings.build());
            if (clusterEnabled && !searchNode) {
                esSettings.put("client.transport.sniff", true);
                Arrays.stream(config.getStringArray("sonar.cluster.search.hosts")).map(HostAndPort::fromString).forEach(h -> EsClientProvider.addHostToClient(h, nativeClient));
                LOGGER.info("Connected to remote Elasticsearch: [{}]", (Object)EsClientProvider.displayedAddresses(nativeClient));
            } else {
                HostAndPort host = HostAndPort.fromParts((String)((String)config.get("sonar.search.host").get()), (int)((Integer)config.getInt("sonar.search.port").get()));
                EsClientProvider.addHostToClient(host, nativeClient);
                LOGGER.info("Connected to local Elasticsearch: [{}]", (Object)EsClientProvider.displayedAddresses(nativeClient));
            }
            this.cache = new EsClient((Client)nativeClient);
        }
        return this.cache;
    }

    private static void addHostToClient(HostAndPort host, TransportClient client) {
        try {
            client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(host.getHostText()), host.getPortOrDefault(9001)));
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Can not resolve host [" + host + "]", e);
        }
    }

    private static String displayedAddresses(TransportClient nativeClient) {
        return nativeClient.transportAddresses().stream().map(TransportAddress::toString).collect(Collectors.joining(", "));
    }

    static class MinimalTransportClient
    extends TransportClient {
        MinimalTransportClient(Settings settings) {
            super(settings, Collections.unmodifiableList(Arrays.asList(Netty4Plugin.class, ReindexPlugin.class, PercolatorPlugin.class, ParentJoinPlugin.class)));
        }

        public void close() {
            super.close();
            if (!NetworkModule.TRANSPORT_TYPE_SETTING.exists(this.settings) || ((String)NetworkModule.TRANSPORT_TYPE_SETTING.get(this.settings)).equals("netty4")) {
                try {
                    GlobalEventExecutor.INSTANCE.awaitInactivity(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    ThreadDeathWatcher.awaitInactivity((long)5L, (TimeUnit)TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

