/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Arrays;
import java.util.Locale;
import java.util.SortedMap;
import org.elasticsearch.common.settings.Settings;

public enum DefaultIndexSettingsElement {
    WORD_FILTER("filter"){

        @Override
        protected void setup() {
            this.set("type", "word_delimiter");
            this.set("generate_word_parts", true);
            this.set("catenate_words", true);
            this.set("catenate_numbers", true);
            this.set("catenate_all", true);
            this.set("split_on_case_change", true);
            this.set("preserve_original", true);
            this.set("split_on_numerics", true);
            this.set("stem_english_possessive", true);
        }
    }
    ,
    NGRAM_FILTER("filter"){

        @Override
        protected void setup() {
            this.set("type", "nGram");
            this.set("min_gram", 2);
            this.set("max_gram", 15);
            this.setArray("token_chars", "letter", "digit", "punctuation", "symbol");
        }
    }
    ,
    GRAM_TOKENIZER("tokenizer"){

        @Override
        protected void setup() {
            this.set("type", "nGram");
            this.set("min_gram", 2);
            this.set("max_gram", 15);
            this.setArray("token_chars", "letter", "digit", "punctuation", "symbol");
        }
    }
    ,
    PREFIX_TOKENIZER("tokenizer"){

        @Override
        protected void setup() {
            this.set("type", "edgeNGram");
            this.set("min_gram", 2);
            this.set("max_gram", 15);
        }
    }
    ,
    UUID_MODULE_TOKENIZER("tokenizer"){

        @Override
        protected void setup() {
            this.set("type", "pattern");
            this.set("pattern", "\\.");
        }
    }
    ,
    SORTABLE_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", "keyword");
            this.setArray("filter", "trim", "lowercase");
        }

        @Override
        public SortedMap<String, String> fieldMapping() {
            return ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"text", (Comparable)((Object)"index"), (Object)"true", (Comparable)((Object)"analyzer"), (Object)this.getName(), (Comparable)((Object)"fielddata"), (Object)"true");
        }
    }
    ,
    INDEX_GRAMS_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", GRAM_TOKENIZER);
            this.setArray("filter", "trim", "lowercase");
        }
    }
    ,
    SEARCH_GRAMS_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", "whitespace");
            this.setArray("filter", "trim", "lowercase");
        }

        @Override
        public SortedMap<String, String> fieldMapping() {
            return ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"text", (Comparable)((Object)"index"), (Object)"true", (Comparable)((Object)"analyzer"), (Object)INDEX_GRAMS_ANALYZER.getName(), (Comparable)((Object)"search_analyzer"), (Object)this.getName());
        }
    }
    ,
    INDEX_PREFIX_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", PREFIX_TOKENIZER);
            this.setArray("filter", "trim");
        }
    }
    ,
    SEARCH_PREFIX_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", "whitespace");
            this.setArray("filter", "trim");
        }

        @Override
        public SortedMap<String, String> fieldMapping() {
            return ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"text", (Comparable)((Object)"index"), (Object)"true", (Comparable)((Object)"analyzer"), (Object)INDEX_PREFIX_ANALYZER.getName(), (Comparable)((Object)"search_analyzer"), (Object)this.getName());
        }
    }
    ,
    INDEX_PREFIX_CASE_INSENSITIVE_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", PREFIX_TOKENIZER);
            this.setArray("filter", "trim", "lowercase");
        }
    }
    ,
    SEARCH_PREFIX_CASE_INSENSITIVE_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", "whitespace");
            this.setArray("filter", "trim", "lowercase");
        }

        @Override
        public SortedMap<String, String> fieldMapping() {
            return ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"text", (Comparable)((Object)"index"), (Object)"true", (Comparable)((Object)"analyzer"), (Object)INDEX_PREFIX_CASE_INSENSITIVE_ANALYZER.getName(), (Comparable)((Object)"search_analyzer"), (Object)this.getName());
        }
    }
    ,
    USER_INDEX_GRAMS_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", "whitespace");
            this.setArray("filter", "trim", "lowercase", NGRAM_FILTER.getName());
        }
    }
    ,
    USER_SEARCH_GRAMS_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", "whitespace");
            this.setArray("filter", "trim", "lowercase");
        }

        @Override
        public SortedMap<String, String> fieldMapping() {
            return ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"text", (Comparable)((Object)"index"), (Object)"true", (Comparable)((Object)"analyzer"), (Object)USER_INDEX_GRAMS_ANALYZER.getName(), (Comparable)((Object)"search_analyzer"), (Object)this.getName());
        }
    }
    ,
    INDEX_WORDS_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", "standard");
            this.setArray("filter", "standard", "word_filter", "lowercase", "stop", "asciifolding", "porter_stem");
        }
    }
    ,
    SEARCH_WORDS_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", "standard");
            this.setArray("filter", "standard", "lowercase", "stop", "asciifolding", "porter_stem");
        }

        @Override
        public SortedMap<String, String> fieldMapping() {
            return ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"text", (Comparable)((Object)"index"), (Object)"true", (Comparable)((Object)"analyzer"), (Object)INDEX_WORDS_ANALYZER.getName(), (Comparable)((Object)"search_analyzer"), (Object)this.getName());
        }
    }
    ,
    ENGLISH_HTML_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", "standard");
            this.setArray("filter", "standard", "lowercase", "stop", "asciifolding", "porter_stem");
            this.setArray("char_filter", "html_strip");
        }

        @Override
        public SortedMap<String, String> fieldMapping() {
            return ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"text", (Comparable)((Object)"index"), (Object)"true", (Comparable)((Object)"analyzer"), (Object)this.getName());
        }
    }
    ,
    PATH_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", "path_hierarchy");
        }
    }
    ,
    UUID_MODULE_ANALYZER("analyzer"){

        @Override
        protected void setup() {
            this.set("tokenizer", UUID_MODULE_TOKENIZER);
            this.setArray("filter", "trim");
        }
    };

    private final String type;
    private final String name;
    private Settings.Builder builder = Settings.builder();

    private DefaultIndexSettingsElement(String type) {
        this.type = type;
        this.name = this.name().toLowerCase(Locale.ENGLISH);
        this.setup();
    }

    protected void set(String settingSuffix, int value) {
        this.put(this.localName(settingSuffix), Integer.toString(value));
    }

    protected void set(String settingSuffix, boolean value) {
        this.put(this.localName(settingSuffix), Boolean.toString(value));
    }

    protected void set(String settingSuffix, DefaultIndexSettingsElement otherElement) {
        this.put(this.localName(settingSuffix), otherElement.name);
    }

    protected void set(String settingSuffix, String value) {
        this.put(this.localName(settingSuffix), value);
    }

    protected void setArray(String settingSuffix, String ... values) {
        this.putArray(this.localName(settingSuffix), values);
    }

    protected void setArray(String settingSuffix, DefaultIndexSettingsElement ... values) {
        this.putArray(this.localName(settingSuffix), (String[])Arrays.stream(values).map(DefaultIndexSettingsElement::getName).toArray(String[]::new));
    }

    private void put(String setting, String value) {
        this.builder = this.builder.put(setting, value);
    }

    private void putArray(String setting, String ... values) {
        this.builder = this.builder.putArray(setting, values);
    }

    private String localName(String settingSuffix) {
        return "index.analysis." + this.type + "." + this.name + "." + settingSuffix;
    }

    public Settings settings() {
        return this.builder.build();
    }

    protected abstract void setup();

    public SortedMap<String, String> fieldMapping() {
        throw new UnsupportedOperationException("The elasticsearch configuration element '" + this.name + "' cannot be used as field mapping.");
    }

    public String subField(String fieldName) {
        return fieldName + "." + this.getSubFieldSuffix();
    }

    public String getSubFieldSuffix() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }
}

