/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.edition.ws;

import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.edition.EditionManagementState;
import org.sonar.server.edition.ws.EditionsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsEditions;

public class StatusAction
implements EditionsWsAction {
    private final UserSession userSession;
    private final EditionManagementState editionManagementState;

    public StatusAction(UserSession userSession, EditionManagementState editionManagementState) {
        this.userSession = userSession;
        this.editionManagementState = editionManagementState;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("status").setSince("6.7").setPost(false).setDescription("Provide status of SonarSource commercial edition of the current SonarQube. Requires 'Administer System' permission.").setResponseExample(this.getClass().getResource("example-edition-status.json")).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        WsEditions.StatusResponse.Builder responseBuilder = WsEditions.StatusResponse.newBuilder().setCurrentEditionKey(this.editionManagementState.getCurrentEditionKey().orElse("")).setNextEditionKey(this.editionManagementState.getPendingEditionKey().orElse("")).setInstallationStatus(WsEditions.InstallationStatus.valueOf((String)this.editionManagementState.getPendingInstallationStatus().name()));
        this.editionManagementState.getInstallErrorMessage().ifPresent(arg_0 -> ((WsEditions.StatusResponse.Builder)responseBuilder).setInstallError(arg_0));
        WsUtils.writeProtobuf((Message)responseBuilder.build(), request, response);
    }
}

