/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.edition.ws;

import com.google.protobuf.Message;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.edition.EditionManagementState;
import org.sonar.server.edition.License;
import org.sonar.server.edition.ws.EditionsWsAction;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.platform.WebServer;
import org.sonar.server.plugins.edition.EditionInstaller;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsEditions;

public class PreviewAction
implements EditionsWsAction {
    private static final String PARAM_LICENSE = "license";
    private final UserSession userSession;
    private final EditionManagementState editionManagementState;
    private final EditionInstaller editionInstaller;
    private final WebServer webServer;

    public PreviewAction(UserSession userSession, EditionManagementState editionManagementState, EditionInstaller editionInstaller, WebServer webServer) {
        this.userSession = userSession;
        this.editionManagementState = editionManagementState;
        this.editionInstaller = editionInstaller;
        this.webServer = webServer;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("preview").setSince("6.7").setPost(true).setDescription("Preview the changes to SonarQube to match the specified license. Requires 'Administer System' permission.").setResponseExample(this.getClass().getResource("example-edition-preview.json")).setHandler((RequestHandler)this);
        action.createParam(PARAM_LICENSE).setRequired(true).setSince("6.7").setDescription("the license");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        if (this.editionManagementState.getPendingInstallationStatus() != EditionManagementState.PendingStatus.NONE) {
            throw BadRequestException.create("Can't apply a license when applying one is already in progress");
        }
        String licenseParam = request.mandatoryParam(PARAM_LICENSE);
        if (licenseParam.isEmpty()) {
            throw new IllegalArgumentException(String.format("The '%s' parameter is empty", PARAM_LICENSE));
        }
        License newLicense = License.parse(licenseParam).orElseThrow(() -> BadRequestException.create("The license provided is invalid"));
        NextState nextState = this.computeNextState(newLicense);
        WsUtils.writeProtobuf((Message)PreviewAction.buildResponse(nextState), request, response);
    }

    private static WsEditions.PreviewResponse buildResponse(NextState nextState) {
        return WsEditions.PreviewResponse.newBuilder().setNextEditionKey(nextState.getPendingEditionKey().orElse("")).setPreviewStatus(nextState.getPreviewStatus()).build();
    }

    private NextState computeNextState(License newLicense) {
        if (!this.webServer.isStandalone() || !this.editionInstaller.requiresInstallationChange(newLicense.getPluginKeys())) {
            return new NextState(newLicense.getEditionKey(), WsEditions.PreviewStatus.NO_INSTALL);
        }
        if (this.editionInstaller.isOffline()) {
            return new NextState(newLicense.getEditionKey(), WsEditions.PreviewStatus.MANUAL_INSTALL);
        }
        return new NextState(newLicense.getEditionKey(), WsEditions.PreviewStatus.AUTOMATIC_INSTALL);
    }

    private static final class NextState {
        private final String pendingEditionKey;
        private final WsEditions.PreviewStatus previewStatus;

        private NextState(@Nullable String pendingEditionKey, WsEditions.PreviewStatus previewStatus) {
            this.pendingEditionKey = pendingEditionKey;
            this.previewStatus = previewStatus;
        }

        Optional<String> getPendingEditionKey() {
            return Optional.ofNullable(this.pendingEditionKey);
        }

        WsEditions.PreviewStatus getPreviewStatus() {
            return this.previewStatus;
        }
    }
}

