/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.resources.Language;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.core.util.UtcDateUtils;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.event.Event;
import org.sonar.server.computation.task.projectanalysis.event.EventRepository;
import org.sonar.server.computation.task.projectanalysis.language.LanguageRepository;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;
import org.sonar.server.qualityprofile.QPMeasureData;
import org.sonar.server.qualityprofile.QualityProfile;

public class QualityProfileEventsStep
implements ComputationStep {
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final EventRepository eventRepository;
    private final LanguageRepository languageRepository;

    public QualityProfileEventsStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, LanguageRepository languageRepository, EventRepository eventRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.eventRepository = eventRepository;
        this.languageRepository = languageRepository;
    }

    @Override
    public void execute() {
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.PROJECT, ComponentVisitor.Order.POST_ORDER){

            @Override
            public void visitProject(Component tree) {
                QualityProfileEventsStep.this.executeForProject(tree);
            }
        }).visit(this.treeRootHolder.getRoot());
    }

    private void executeForProject(Component projectComponent) {
        Optional<Measure> baseMeasure = this.measureRepository.getBaseMeasure(projectComponent, this.metricRepository.getByKey("quality_profiles"));
        if (!baseMeasure.isPresent()) {
            return;
        }
        Optional<Measure> rawMeasure = this.measureRepository.getRawMeasure(projectComponent, this.metricRepository.getByKey("quality_profiles"));
        if (!rawMeasure.isPresent()) {
            return;
        }
        Map<String, QualityProfile> rawProfiles = QPMeasureData.fromJson(((Measure)rawMeasure.get()).getStringValue()).getProfilesByKey();
        Map<String, QualityProfile> baseProfiles = QualityProfileEventsStep.parseJsonData(baseMeasure);
        this.detectNewOrUpdatedProfiles(projectComponent, baseProfiles, rawProfiles);
        this.detectNoMoreUsedProfiles(projectComponent, baseProfiles, rawProfiles);
    }

    private static Map<String, QualityProfile> parseJsonData(Optional<Measure> measure) {
        String data = ((Measure)measure.get()).getStringValue();
        if (data == null) {
            return Collections.emptyMap();
        }
        return QPMeasureData.fromJson(data).getProfilesByKey();
    }

    private void detectNoMoreUsedProfiles(Component context, Map<String, QualityProfile> baseProfiles, Map<String, QualityProfile> rawProfiles) {
        for (QualityProfile baseProfile : baseProfiles.values()) {
            if (rawProfiles.containsKey(baseProfile.getQpKey())) continue;
            this.markAsRemoved(context, baseProfile);
        }
    }

    private void detectNewOrUpdatedProfiles(Component component, Map<String, QualityProfile> baseProfiles, Map<String, QualityProfile> rawProfiles) {
        for (QualityProfile profile : rawProfiles.values()) {
            QualityProfile baseProfile = baseProfiles.get(profile.getQpKey());
            if (baseProfile == null) {
                this.markAsAdded(component, profile);
                continue;
            }
            if (!profile.getRulesUpdatedAt().after(baseProfile.getRulesUpdatedAt())) continue;
            this.markAsChanged(component, baseProfile, profile);
        }
    }

    private void markAsChanged(Component component, QualityProfile baseProfile, QualityProfile profile) {
        Date from = baseProfile.getRulesUpdatedAt();
        String data = KeyValueFormat.format((Map)ImmutableSortedMap.of((Comparable)((Object)"key"), (Object)profile.getQpKey(), (Comparable)((Object)"from"), (Object)UtcDateUtils.formatDateTime((Date)QualityProfileEventsStep.fixDate(from)), (Comparable)((Object)"to"), (Object)UtcDateUtils.formatDateTime((Date)QualityProfileEventsStep.fixDate(profile.getRulesUpdatedAt()))));
        this.eventRepository.add(component, this.createQProfileEvent(profile, "Changes in %s", data));
    }

    private void markAsRemoved(Component component, QualityProfile profile) {
        this.eventRepository.add(component, this.createQProfileEvent(profile, "Stop using %s"));
    }

    private void markAsAdded(Component component, QualityProfile profile) {
        this.eventRepository.add(component, this.createQProfileEvent(profile, "Use %s"));
    }

    private Event createQProfileEvent(QualityProfile profile, String namePattern) {
        return this.createQProfileEvent(profile, namePattern, null);
    }

    private Event createQProfileEvent(QualityProfile profile, String namePattern, @Nullable String data) {
        return Event.createProfile(String.format(namePattern, this.profileLabel(profile)), data, null);
    }

    private String profileLabel(QualityProfile profile) {
        Optional<Language> language = this.languageRepository.find(profile.getLanguageKey());
        String languageName = language.isPresent() ? ((Language)language.get()).getName() : profile.getLanguageKey();
        return String.format("'%s' (%s)", profile.getQpName(), languageName);
    }

    private static Date fixDate(Date date) {
        return DateUtils.addSeconds((Date)date, (int)1);
    }

    @Override
    public String getDescription() {
        return "Generate Quality profile events";
    }
}

