/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.MeasureDao;
import org.sonar.db.measure.MeasureDto;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.measure.BestValueOptimization;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureToMeasureDto;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class PersistMeasuresStep
implements ComputationStep {
    private static final List<String> NOT_TO_PERSIST_ON_FILE_METRIC_KEYS = ImmutableList.of((Object)"file_complexity_distribution", (Object)"function_complexity_distribution", (Object)"class_complexity_distribution");
    private final DbClient dbClient;
    private final MetricRepository metricRepository;
    private final MeasureToMeasureDto measureToMeasureDto;
    private final TreeRootHolder treeRootHolder;
    private final MeasureRepository measureRepository;

    public PersistMeasuresStep(DbClient dbClient, MetricRepository metricRepository, MeasureToMeasureDto measureToMeasureDto, TreeRootHolder treeRootHolder, MeasureRepository measureRepository) {
        this.dbClient = dbClient;
        this.metricRepository = metricRepository;
        this.measureToMeasureDto = measureToMeasureDto;
        this.treeRootHolder = treeRootHolder;
        this.measureRepository = measureRepository;
    }

    @Override
    public String getDescription() {
        return "Persist measures";
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(true);){
            new DepthTraversalTypeAwareCrawler(new MeasureVisitor(dbSession)).visit(this.treeRootHolder.getRoot());
            dbSession.commit();
        }
    }

    private static enum NonEmptyMeasure implements Predicate<Measure>
    {
        INSTANCE;


        public boolean apply(@Nonnull Measure input) {
            return input.getValueType() != Measure.ValueType.NO_VALUE || input.hasVariation() || input.getData() != null;
        }
    }

    private class MeasureVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;

        private MeasureVisitor(DbSession session) {
            super(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.PRE_ORDER);
            this.session = session;
        }

        @Override
        public void visitAny(Component component) {
            SetMultimap<String, Measure> measures = PersistMeasuresStep.this.measureRepository.getRawMeasures(component);
            this.persistMeasures(component, (Multimap<String, Measure>)measures);
        }

        private void persistMeasures(Component component, Multimap<String, Measure> batchReportMeasures) {
            for (Map.Entry measures : batchReportMeasures.asMap().entrySet()) {
                String metricKey = (String)measures.getKey();
                if (NOT_TO_PERSIST_ON_FILE_METRIC_KEYS.contains(metricKey) && component.getType() == Component.Type.FILE) continue;
                Metric metric = PersistMeasuresStep.this.metricRepository.getByKey(metricKey);
                Predicate notBestValueOptimized = Predicates.not(BestValueOptimization.from(metric, component));
                MeasureDao measureDao = PersistMeasuresStep.this.dbClient.measureDao();
                for (Measure measure : FluentIterable.from((Iterable)((Iterable)measures.getValue())).filter((Predicate)NonEmptyMeasure.INSTANCE).filter(notBestValueOptimized)) {
                    MeasureDto measureDto = PersistMeasuresStep.this.measureToMeasureDto.toMeasureDto(measure, metric, component);
                    measureDao.insert(this.session, measureDto);
                }
            }
        }
    }
}

