/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;
import org.sonar.api.utils.dag.DirectAcyclicGraph;
import org.sonar.server.computation.task.projectanalysis.api.measurecomputer.MeasureComputerDefinitionImpl;
import org.sonar.server.computation.task.projectanalysis.api.measurecomputer.MeasureComputerWrapper;
import org.sonar.server.computation.task.projectanalysis.measure.MutableMeasureComputersHolder;
import org.sonar.server.computation.task.step.ComputationStep;

public class LoadMeasureComputersStep
implements ComputationStep {
    private static final Set<String> CORE_METRIC_KEYS = FluentIterable.from((Iterable)CoreMetrics.getMetrics()).transform((Function)MetricToKey.INSTANCE).toSet();
    private Set<String> pluginMetricKeys;
    private final MutableMeasureComputersHolder measureComputersHolder;
    private final MeasureComputer[] measureComputers;

    public LoadMeasureComputersStep(MutableMeasureComputersHolder measureComputersHolder, Metrics[] metricsRepositories, MeasureComputer[] measureComputers) {
        this.measureComputersHolder = measureComputersHolder;
        this.measureComputers = measureComputers;
        this.pluginMetricKeys = FluentIterable.from(Arrays.asList(metricsRepositories)).transformAndConcat((Function)MetricsToMetricList.INSTANCE).transform((Function)MetricToKey.INSTANCE).toSet();
    }

    public LoadMeasureComputersStep(MutableMeasureComputersHolder measureComputersHolder, MeasureComputer[] measureComputers) {
        this(measureComputersHolder, new Metrics[0], measureComputers);
    }

    public LoadMeasureComputersStep(MutableMeasureComputersHolder measureComputersHolder, Metrics[] metricsRepositories) {
        this(measureComputersHolder, metricsRepositories, new MeasureComputer[0]);
    }

    public LoadMeasureComputersStep(MutableMeasureComputersHolder measureComputersHolder) {
        this(measureComputersHolder, new Metrics[0], new MeasureComputer[0]);
    }

    @Override
    public void execute() {
        ImmutableList wrappers = FluentIterable.from(Arrays.asList(this.measureComputers)).transform((Function)ToMeasureWrapper.INSTANCE).toList();
        this.validateMetrics((List<MeasureComputerWrapper>)wrappers);
        this.measureComputersHolder.setMeasureComputers(LoadMeasureComputersStep.sortComputers((List<MeasureComputerWrapper>)wrappers));
    }

    private static Iterable<MeasureComputerWrapper> sortComputers(List<MeasureComputerWrapper> wrappers) {
        HashMap<String, MeasureComputerWrapper> computersByOutputMetric = new HashMap<String, MeasureComputerWrapper>();
        HashMap<String, MeasureComputerWrapper> computersByInputMetric = new HashMap<String, MeasureComputerWrapper>();
        LoadMeasureComputersStep.feedComputersByMetric(wrappers, computersByOutputMetric, computersByInputMetric);
        ToComputerByKey toComputerByOutputMetricKey = new ToComputerByKey(computersByOutputMetric);
        ToComputerByKey toComputerByInputMetricKey = new ToComputerByKey(computersByInputMetric);
        DirectAcyclicGraph dag = new DirectAcyclicGraph(new Object[0]);
        for (MeasureComputerWrapper computer : wrappers) {
            dag.add((Object)computer, new Object[0]);
            for (MeasureComputerWrapper dependency : LoadMeasureComputersStep.getDependencies(computer, toComputerByOutputMetricKey)) {
                dag.add((Object)computer, new Object[]{dependency});
            }
            for (MeasureComputerWrapper generates : LoadMeasureComputersStep.getDependents(computer, toComputerByInputMetricKey)) {
                dag.add((Object)generates, new Object[]{computer});
            }
        }
        return dag.sort();
    }

    private static void feedComputersByMetric(List<MeasureComputerWrapper> wrappers, Map<String, MeasureComputerWrapper> computersByOutputMetric, Map<String, MeasureComputerWrapper> computersByInputMetric) {
        for (MeasureComputerWrapper computer : wrappers) {
            for (String outputMetric : computer.getDefinition().getOutputMetrics()) {
                computersByOutputMetric.put(outputMetric, computer);
            }
            for (String inputMetric : computer.getDefinition().getInputMetrics()) {
                computersByInputMetric.put(inputMetric, computer);
            }
        }
    }

    private void validateMetrics(List<MeasureComputerWrapper> wrappers) {
        FluentIterable.from(wrappers).transformAndConcat((Function)ToInputMetrics.INSTANCE).filter((Predicate)new ValidateInputMetric()).size();
        FluentIterable.from(wrappers).transformAndConcat((Function)ToOutputMetrics.INSTANCE).filter((Predicate)new ValidateOutputMetric()).size();
        FluentIterable.from(wrappers).filter((Predicate)new ValidateUniqueOutputMetric()).size();
    }

    private static Iterable<MeasureComputerWrapper> getDependencies(MeasureComputerWrapper measureComputer, ToComputerByKey toComputerByOutputMetricKey) {
        return FluentIterable.from((Iterable)measureComputer.getDefinition().getInputMetrics()).transform((Function)toComputerByOutputMetricKey).filter(Predicates.notNull());
    }

    private static Iterable<MeasureComputerWrapper> getDependents(MeasureComputerWrapper measureComputer, ToComputerByKey toComputerByInputMetricKey) {
        return FluentIterable.from((Iterable)measureComputer.getDefinition().getInputMetrics()).transform((Function)toComputerByInputMetricKey);
    }

    @Override
    public String getDescription() {
        return "Load measure computers";
    }

    private static class ValidateUniqueOutputMetric
    implements Predicate<MeasureComputerWrapper> {
        private Set<String> allOutputMetrics = new HashSet<String>();

        private ValidateUniqueOutputMetric() {
        }

        public boolean apply(@Nonnull MeasureComputerWrapper wrapper) {
            for (String outputMetric : wrapper.getDefinition().getOutputMetrics()) {
                Preconditions.checkState((!this.allOutputMetrics.contains(outputMetric) ? 1 : 0) != 0, (String)"Output metric '%s' is already defined by another measure computer '%s'", (Object[])new Object[]{outputMetric, wrapper.getComputer()});
                this.allOutputMetrics.add(outputMetric);
            }
            return true;
        }
    }

    private class ValidateOutputMetric
    implements Predicate<String> {
        private ValidateOutputMetric() {
        }

        public boolean apply(@Nonnull String metric) {
            Preconditions.checkState((!CORE_METRIC_KEYS.contains(metric) ? 1 : 0) != 0, (String)"Metric '%s' cannot be used as an output metric because it's a core metric", (Object[])new Object[]{metric});
            Preconditions.checkState((boolean)LoadMeasureComputersStep.this.pluginMetricKeys.contains(metric), (String)"Metric '%s' cannot be used as an output metric because no plugins declare this metric", (Object[])new Object[]{metric});
            return true;
        }
    }

    private static enum ToOutputMetrics implements Function<MeasureComputerWrapper, Collection<String>>
    {
        INSTANCE;


        public Collection<String> apply(@Nonnull MeasureComputerWrapper input) {
            return input.getDefinition().getOutputMetrics();
        }
    }

    private class ValidateInputMetric
    implements Predicate<String> {
        private ValidateInputMetric() {
        }

        public boolean apply(@Nonnull String metric) {
            Preconditions.checkState((LoadMeasureComputersStep.this.pluginMetricKeys.contains(metric) || CORE_METRIC_KEYS.contains(metric) ? 1 : 0) != 0, (String)"Metric '%s' cannot be used as an input metric as it's not a core metric and no plugin declare this metric", (Object[])new Object[]{metric});
            return true;
        }
    }

    private static enum ToInputMetrics implements Function<MeasureComputerWrapper, Collection<String>>
    {
        INSTANCE;


        public Collection<String> apply(@Nonnull MeasureComputerWrapper input) {
            return input.getDefinition().getInputMetrics();
        }
    }

    private static enum ToMeasureWrapper implements Function<MeasureComputer, MeasureComputerWrapper>
    {
        INSTANCE;


        public MeasureComputerWrapper apply(@Nonnull MeasureComputer measureComputer) {
            MeasureComputer.MeasureComputerDefinition def = measureComputer.define(MeasureComputerDefinitionImpl.BuilderImpl::new);
            return new MeasureComputerWrapper(measureComputer, ToMeasureWrapper.validateDef(def));
        }

        private static MeasureComputer.MeasureComputerDefinition validateDef(MeasureComputer.MeasureComputerDefinition def) {
            if (def instanceof MeasureComputerDefinitionImpl) {
                return def;
            }
            Set inputMetrics = def.getInputMetrics();
            Set outputMetrics = def.getOutputMetrics();
            return new MeasureComputerDefinitionImpl.BuilderImpl().setInputMetrics((String[])FluentIterable.from((Iterable)inputMetrics).toArray(String.class)).setOutputMetrics((String[])FluentIterable.from((Iterable)outputMetrics).toArray(String.class)).build();
        }
    }

    private static enum MetricsToMetricList implements Function<Metrics, List<Metric>>
    {
        INSTANCE;


        public List<Metric> apply(@Nonnull Metrics input) {
            return input.getMetrics();
        }
    }

    private static enum MetricToKey implements Function<Metric, String>
    {
        INSTANCE;


        @Nullable
        public String apply(@Nonnull Metric input) {
            return input.key();
        }
    }

    private static class ToComputerByKey
    implements Function<String, MeasureComputerWrapper> {
        private final Map<String, MeasureComputerWrapper> computersByMetric;

        private ToComputerByKey(Map<String, MeasureComputerWrapper> computersByMetric) {
            this.computersByMetric = computersByMetric;
        }

        public MeasureComputerWrapper apply(@Nonnull String metricKey) {
            return this.computersByMetric.get(metricKey);
        }
    }
}

