/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitygate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.server.computation.task.projectanalysis.qualitygate.Condition;
import org.sonar.server.computation.task.projectanalysis.qualitygate.ConditionStatus;
import org.sonar.server.computation.task.projectanalysis.qualitygate.MutableQualityGateStatusHolder;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGateStatus;

public class QualityGateStatusHolderImpl
implements MutableQualityGateStatusHolder {
    @CheckForNull
    private QualityGateStatus status;
    @CheckForNull
    private Map<Condition, ConditionStatus> statusPerCondition;

    @Override
    public QualityGateStatus getStatus() {
        this.checkInitialized();
        return this.status;
    }

    @Override
    public Map<Condition, ConditionStatus> getStatusPerConditions() {
        this.checkInitialized();
        return this.statusPerCondition;
    }

    private void checkInitialized() {
        Preconditions.checkState((this.status != null ? 1 : 0) != 0, (Object)"Quality gate status has not been set yet");
    }

    @Override
    public void setStatus(QualityGateStatus globalStatus, Map<Condition, ConditionStatus> statusPerCondition) {
        Preconditions.checkState((this.status == null ? 1 : 0) != 0, (Object)"Quality gate status has already been set in the holder");
        Objects.requireNonNull(globalStatus, "global status can not be null");
        Objects.requireNonNull(statusPerCondition, "status per condition can not be null");
        this.status = globalStatus;
        this.statusPerCondition = ImmutableMap.copyOf(statusPerCondition);
    }
}

