/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.period;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.server.computation.task.projectanalysis.period.Period;
import org.sonar.server.computation.task.projectanalysis.period.PeriodHolder;

public class PeriodHolderImpl
implements PeriodHolder {
    @CheckForNull
    private Period period = null;
    private boolean initialized = false;

    public void setPeriod(@Nullable Period period) {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Period have already been initialized");
        this.period = period;
        this.initialized = true;
    }

    @Override
    public boolean hasPeriod() {
        this.checkHolderIsInitialized();
        return this.period != null;
    }

    @Override
    public Period getPeriod() {
        this.checkHolderIsInitialized();
        return this.period;
    }

    private void checkHolderIsInitialized() {
        Preconditions.checkState((boolean)this.initialized, (Object)"Period have not been initialized yet");
    }
}

