/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.metric;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.metric.ScannerMetrics;
import org.sonar.server.computation.task.projectanalysis.metric.ReportMetricValidator;

public class ReportMetricValidatorImpl
implements ReportMetricValidator {
    private static final Logger LOG = Loggers.get(ReportMetricValidatorImpl.class);
    private Map<String, Metric> metricByKey;
    private Set<String> alreadyLoggedMetricKeys = new HashSet<String>();

    public ReportMetricValidatorImpl(ScannerMetrics scannerMetrics) {
        this.metricByKey = FluentIterable.from((Iterable)scannerMetrics.getMetrics()).uniqueIndex((Function)MetricToKey.INSTANCE);
    }

    @Override
    public boolean validate(String metricKey) {
        Metric metric = this.metricByKey.get(metricKey);
        if (metric == null) {
            if (!this.alreadyLoggedMetricKeys.contains(metricKey)) {
                LOG.debug("The metric '{}' is ignored and should not be send in the batch report", (Object)metricKey);
                this.alreadyLoggedMetricKeys.add(metricKey);
            }
            return false;
        }
        return true;
    }

    private static enum MetricToKey implements Function<Metric, String>
    {
        INSTANCE;


        @Nullable
        public String apply(@Nonnull Metric input) {
            return input.key();
        }
    }
}

