/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.language;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sonar.api.resources.Language;
import org.sonar.server.computation.task.projectanalysis.language.LanguageRepository;

public class LanguageRepositoryImpl
implements LanguageRepository {
    private final Map<String, Language> languagesByKey;

    public LanguageRepositoryImpl() {
        this.languagesByKey = Collections.emptyMap();
    }

    public LanguageRepositoryImpl(Language ... languages) {
        this.languagesByKey = Maps.uniqueIndex((Iterable)Iterables.filter(Arrays.asList(languages), (Predicate)Predicates.notNull()), (Function)LanguageToKey.INSTANCE);
    }

    @Override
    public Optional<Language> find(String languageKey) {
        return Optional.fromNullable((Object)this.languagesByKey.get(languageKey));
    }

    private static enum LanguageToKey implements Function<Language, String>
    {
        INSTANCE;


        public String apply(@Nonnull Language input) {
            return input.getKey();
        }
    }
}

