/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue.commonrule;

import com.google.common.base.Optional;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.commonrule.CommonRule;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRulesHolder;

public class CommentDensityRule
extends CommonRule {
    private final MeasureRepository measureRepository;
    private final Metric commentDensityMetric;
    private final Metric commentLinesMetric;
    private final Metric nclocMetric;

    public CommentDensityRule(ActiveRulesHolder activeRulesHolder, MeasureRepository measureRepository, MetricRepository metricRepository) {
        super(activeRulesHolder, "InsufficientCommentDensity");
        this.measureRepository = measureRepository;
        this.commentDensityMetric = metricRepository.getByKey("comment_lines_density");
        this.commentLinesMetric = metricRepository.getByKey("comment_lines");
        this.nclocMetric = metricRepository.getByKey("ncloc");
    }

    @Override
    protected CommonRule.CommonRuleIssue doProcessFile(Component file, ActiveRule activeRule) {
        Optional<Measure> commentDensityMeasure = this.measureRepository.getRawMeasure(file, this.commentDensityMetric);
        Optional<Measure> commentLinesMeasure = this.measureRepository.getRawMeasure(file, this.commentLinesMetric);
        Optional<Measure> nclocMeasure = this.measureRepository.getRawMeasure(file, this.nclocMetric);
        if (commentDensityMeasure.isPresent() && nclocMeasure.isPresent() && ((Measure)nclocMeasure.get()).getIntValue() > 0) {
            double minCommentDensity = this.getMinDensity(activeRule);
            if (((Measure)commentDensityMeasure.get()).getDoubleValue() < minCommentDensity) {
                return CommentDensityRule.generateIssue(commentDensityMeasure, commentLinesMeasure, nclocMeasure, minCommentDensity);
            }
        }
        return null;
    }

    private double getMinDensity(ActiveRule activeRule) {
        double min = CommentDensityRule.getMinDensityParam(activeRule, "minimumCommentDensity");
        if (min >= 100.0) {
            throw new IllegalStateException("Minimum density of rule [" + activeRule.getRuleKey() + "] is incorrect. Got [100] but must be strictly less than 100.");
        }
        return min;
    }

    private static CommonRule.CommonRuleIssue generateIssue(Optional<Measure> commentDensityMeasure, Optional<Measure> commentLinesMeasure, Optional<Measure> nclocMeasure, double minCommentDensity) {
        int commentLines = commentLinesMeasure.isPresent() ? ((Measure)commentLinesMeasure.get()).getIntValue() : 0;
        int ncloc = ((Measure)nclocMeasure.get()).getIntValue();
        int minExpectedCommentLines = (int)Math.ceil(minCommentDensity * (double)ncloc / (100.0 - minCommentDensity));
        int missingCommentLines = minExpectedCommentLines - commentLines;
        if (missingCommentLines <= 0) {
            throw new IllegalStateException(String.format("Bug in measures of comment lines - density=%s, comment_lines= %d, ncloc=%d, threshold=%s%%", ((Measure)commentDensityMeasure.get()).getDoubleValue(), commentLines, ((Measure)nclocMeasure.get()).getIntValue(), minCommentDensity));
        }
        String message = String.format("%d more comment lines need to be written to reach the minimum threshold of %s%% comment density.", missingCommentLines, minCommentDensity);
        return new CommonRule.CommonRuleIssue(missingCommentLines, message);
    }
}

