/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.Optional;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.server.computation.task.projectanalysis.issue.ComponentsWithUnprocessedIssues;
import org.sonar.server.computation.task.projectanalysis.issue.IssueVisitor;

public class RemoveProcessedComponentsVisitor
extends IssueVisitor {
    private final ComponentsWithUnprocessedIssues componentsWithUnprocessedIssues;
    private final MovedFilesRepository movedFilesRepository;

    public RemoveProcessedComponentsVisitor(ComponentsWithUnprocessedIssues componentsWithUnprocessedIssues, MovedFilesRepository movedFilesRepository) {
        this.componentsWithUnprocessedIssues = componentsWithUnprocessedIssues;
        this.movedFilesRepository = movedFilesRepository;
    }

    @Override
    public void afterComponent(Component component) {
        this.componentsWithUnprocessedIssues.remove(component.getUuid());
        Optional<MovedFilesRepository.OriginalFile> originalFile = this.movedFilesRepository.getOriginalFile(component);
        if (originalFile.isPresent()) {
            this.componentsWithUnprocessedIssues.remove(((MovedFilesRepository.OriginalFile)originalFile.get()).getUuid());
        }
    }
}

