/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.IssueVisitor;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.period.Period;
import org.sonar.server.computation.task.projectanalysis.period.PeriodHolder;

public class NewEffortAggregator
extends IssueVisitor {
    private final PeriodHolder periodHolder;
    private final MeasureRepository measureRepository;
    private final Metric newMaintainabilityEffortMetric;
    private final Metric newReliabilityEffortMetric;
    private final Metric newSecurityEffortMetric;
    private Map<Integer, NewEffortCounter> counterByComponentRef = new HashMap<Integer, NewEffortCounter>();
    private NewEffortCounter counter = null;

    public NewEffortAggregator(PeriodHolder periodHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.periodHolder = periodHolder;
        this.measureRepository = measureRepository;
        this.newMaintainabilityEffortMetric = metricRepository.getByKey("new_technical_debt");
        this.newReliabilityEffortMetric = metricRepository.getByKey("new_reliability_remediation_effort");
        this.newSecurityEffortMetric = metricRepository.getByKey("new_security_remediation_effort");
    }

    @Override
    public void beforeComponent(Component component) {
        this.counter = new NewEffortCounter();
        this.counterByComponentRef.put(component.getReportAttributes().getRef(), this.counter);
        for (Component child : component.getChildren()) {
            NewEffortCounter childSum = this.counterByComponentRef.remove(child.getReportAttributes().getRef());
            if (childSum == null) continue;
            this.counter.add(childSum);
        }
    }

    @Override
    public void onIssue(Component component, DefaultIssue issue) {
        if (issue.resolution() == null && issue.effortInMinutes() != null && this.periodHolder.hasPeriod()) {
            this.counter.add(issue, this.periodHolder.getPeriod());
        }
    }

    @Override
    public void afterComponent(Component component) {
        this.computeMeasure(component, this.newMaintainabilityEffortMetric, this.counter.maintainabilitySum);
        this.computeMeasure(component, this.newReliabilityEffortMetric, this.counter.reliabilitySum);
        this.computeMeasure(component, this.newSecurityEffortMetric, this.counter.securitySum);
        this.counter = null;
    }

    private void computeMeasure(Component component, Metric metric, EffortSum effortSum) {
        if (!effortSum.isEmpty) {
            this.measureRepository.add(component, metric, Measure.newMeasureBuilder().setVariation(effortSum.newEffort).createNoValue());
        }
    }

    private static class EffortSum {
        private Double newEffort;
        private boolean isEmpty = true;

        private EffortSum() {
        }

        void add(long newEffort) {
            double previous = (Double)MoreObjects.firstNonNull((Object)this.newEffort, (Object)0.0);
            this.newEffort = previous + (double)newEffort;
            this.isEmpty = false;
        }

        void add(EffortSum other) {
            Double otherValue = other.newEffort;
            if (otherValue != null) {
                this.add(otherValue.longValue());
            }
        }
    }

    private static class NewEffortCounter {
        private final EffortSum maintainabilitySum = new EffortSum();
        private final EffortSum reliabilitySum = new EffortSum();
        private final EffortSum securitySum = new EffortSum();

        private NewEffortCounter() {
        }

        void add(NewEffortCounter otherCounter) {
            this.maintainabilitySum.add(otherCounter.maintainabilitySum);
            this.reliabilitySum.add(otherCounter.reliabilitySum);
            this.securitySum.add(otherCounter.securitySum);
        }

        void add(DefaultIssue issue, Period period) {
            long newEffort = this.calculate(issue, period);
            switch (issue.type()) {
                case CODE_SMELL: {
                    this.maintainabilitySum.add(newEffort);
                    break;
                }
                case BUG: {
                    this.reliabilitySum.add(newEffort);
                    break;
                }
                case VULNERABILITY: {
                    this.securitySum.add(newEffort);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown type '%s'", issue.type()));
                }
            }
        }

        long calculate(DefaultIssue issue, Period period) {
            if (issue.creationDate().getTime() > DateUtils.truncateToSeconds((long)period.getSnapshotDate())) {
                return (Long)MoreObjects.firstNonNull((Object)issue.effortInMinutes(), (Object)0L);
            }
            return 0L;
        }
    }
}

