/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.formula.coverage;

import com.google.common.base.Optional;
import org.sonar.server.computation.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.CoverageUtils;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.ElementsAndCoveredElementsCounter;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;

public abstract class CoverageFormula<T extends ElementsAndCoveredElementsCounter>
implements Formula<T> {
    @Override
    public Optional<Measure> createMeasure(T counter, CreateMeasureContext context) {
        long elements = ((ElementsAndCoveredElementsCounter)counter).elements;
        long coveredElements = ((ElementsAndCoveredElementsCounter)counter).coveredElements;
        if (elements > 0L) {
            return Optional.of((Object)Measure.newMeasureBuilder().create(CoverageUtils.calculateCoverage(coveredElements, elements), context.getMetric().getDecimalScale()));
        }
        return Optional.absent();
    }
}

