/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;

public class MergeBranchComponentUuids {
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final DbClient dbClient;
    private Map<String, String> uuidsByKey;
    private String mergeBranchName;

    public MergeBranchComponentUuids(AnalysisMetadataHolder analysisMetadataHolder, DbClient dbClient) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.dbClient = dbClient;
    }

    private void lazyInit() {
        if (this.uuidsByKey == null) {
            String mergeBranchUuid = this.analysisMetadataHolder.getBranch().getMergeBranchUuid().get();
            this.uuidsByKey = new HashMap<String, String>();
            try (DbSession dbSession = this.dbClient.openSession(false);){
                List components = this.dbClient.componentDao().selectByProjectUuid(mergeBranchUuid, dbSession);
                for (ComponentDto dto : components) {
                    this.uuidsByKey.put(dto.getKey(), dto.uuid());
                }
                this.mergeBranchName = ((BranchDto)this.dbClient.branchDao().selectByUuid(dbSession, mergeBranchUuid).get()).getKey();
            }
        }
    }

    public String getMergeBranchName() {
        this.lazyInit();
        return this.mergeBranchName;
    }

    @CheckForNull
    public String getUuid(String dbKey) {
        this.lazyInit();
        String cleanComponentKey = ComponentDto.removeBranchFromKey((String)dbKey);
        return this.uuidsByKey.get(cleanComponentKey);
    }
}

