/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.DbIdsRepository;
import org.sonar.server.computation.task.projectanalysis.component.Developer;
import org.sonar.server.computation.task.projectanalysis.component.MutableDbIdsRepository;

public final class MapBasedDbIdsRepository<T>
implements MutableDbIdsRepository {
    private final Function<Component, T> componentToKey;
    private final Map<T, Long> componentIdsByRef = new HashMap<T, Long>();
    private final Map<Developer, Long> developerIdsByKey = new HashMap<Developer, Long>();

    public MapBasedDbIdsRepository(Function<Component, T> componentToKey) {
        this.componentToKey = componentToKey;
    }

    @Override
    public DbIdsRepository setComponentId(Component component, long componentId) {
        Object ref = this.componentToKey.apply((Object)component);
        Long existingComponentId = this.componentIdsByRef.get(ref);
        Preconditions.checkState((existingComponentId == null ? 1 : 0) != 0, (String)"Component id '%s' is already registered in repository for Component '%s', can not set new id '%s'", (Object[])new Object[]{existingComponentId, component.getKey(), componentId});
        this.componentIdsByRef.put(ref, componentId);
        return this;
    }

    @Override
    public long getComponentId(Component component) {
        Object ref = this.componentToKey.apply((Object)component);
        Long componentId = this.componentIdsByRef.get(ref);
        Preconditions.checkState((componentId != null ? 1 : 0) != 0, (String)"No component id registered in repository for Component '%s'", (Object[])new Object[]{component.getKey()});
        return componentId;
    }

    @Override
    public DbIdsRepository setDeveloperId(Developer developer, long developerId) {
        Long existingId = this.developerIdsByKey.get(developer);
        Preconditions.checkState((existingId == null ? 1 : 0) != 0, (String)"Id '%s' is already registered in repository for Developer '%s', can not set new id '%s'", (Object[])new Object[]{existingId, developer, developerId});
        this.developerIdsByKey.put(developer, developerId);
        return this;
    }

    @Override
    public long getDeveloperId(Developer developer) {
        Long devId = this.developerIdsByKey.get(developer);
        Preconditions.checkState((devId != null ? 1 : 0) != 0, (String)"No id registered in repository for Developer '%s'", (Object[])new Object[]{developer});
        return devId;
    }
}

