/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import com.google.common.base.Optional;
import java.util.Date;
import javax.annotation.Nullable;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.analysis.Branch;
import org.sonar.server.computation.task.projectanalysis.component.BranchPersister;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;

public class BranchPersisterImpl
implements BranchPersister {
    private final DbClient dbClient;
    private final System2 system2;
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public BranchPersisterImpl(DbClient dbClient, System2 system2, TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder) {
        this.dbClient = dbClient;
        this.system2 = system2;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public void persist(DbSession dbSession) {
        ComponentDto branchComponentDto;
        Branch branch = this.analysisMetadataHolder.getBranch();
        String branchUuid = this.treeRootHolder.getRoot().getUuid();
        Optional branchComponentDtoOpt = this.dbClient.componentDao().selectByUuid(dbSession, branchUuid);
        if (branch.isMain()) {
            BranchPersisterImpl.checkState(branchComponentDtoOpt.isPresent(), "Project has been deleted by end-user during analysis");
            branchComponentDto = (ComponentDto)branchComponentDtoOpt.get();
        } else {
            branchComponentDto = (ComponentDto)branchComponentDtoOpt.or(() -> this.insertIntoProjectsTable(dbSession, branchUuid));
        }
        this.dbClient.branchDao().upsert(dbSession, BranchPersisterImpl.toBranchDto(branchComponentDto, branch));
    }

    private static void checkState(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalStateException(msg);
        }
    }

    private static <T> T firstNonNull(@Nullable T first, T second) {
        return first != null ? first : second;
    }

    private static BranchDto toBranchDto(ComponentDto componentDto, Branch branch) {
        BranchDto dto = new BranchDto();
        dto.setUuid(componentDto.uuid());
        dto.setProjectUuid(BranchPersisterImpl.firstNonNull(componentDto.getMainBranchProjectUuid(), componentDto.projectUuid()));
        dto.setKey(branch.getName());
        dto.setBranchType(branch.getType());
        dto.setMergeBranchUuid((String)branch.getMergeBranchUuid().orElse(null));
        return dto;
    }

    private ComponentDto insertIntoProjectsTable(DbSession dbSession, String branchUuid) {
        String mainBranchProjectUuid = this.analysisMetadataHolder.getProject().getUuid();
        ComponentDto project = this.dbClient.componentDao().selectOrFailByUuid(dbSession, mainBranchProjectUuid);
        ComponentDto branchDto = project.copy();
        branchDto.setUuid(branchUuid);
        branchDto.setProjectUuid(branchUuid);
        branchDto.setRootUuid(branchUuid);
        branchDto.setUuidPath(".");
        branchDto.setModuleUuidPath("." + branchUuid + ".");
        branchDto.setMainBranchProjectUuid(mainBranchProjectUuid);
        branchDto.setDbKey(this.treeRootHolder.getRoot().getKey());
        branchDto.setCreatedAt(new Date(this.system2.now()));
        this.dbClient.componentDao().insert(dbSession, branchDto);
        return branchDto;
    }
}

