/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.analysis;

import javax.annotation.concurrent.Immutable;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.computation.task.projectanalysis.component.Component;

@Immutable
public class Project {
    private final String uuid;
    private final String key;
    private final String name;

    public Project(String uuid, String key, String name) {
        this.uuid = uuid;
        this.key = key;
        this.name = name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return this.uuid.equals(project.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Project{");
        sb.append("uuid='").append(this.uuid).append('\'');
        sb.append(", key='").append(this.key).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static Project copyOf(Component component) {
        return new Project(component.getUuid(), component.getKey(), component.getName());
    }

    public static Project copyOf(ComponentDto component) {
        return new Project(component.uuid(), component.getDbKey(), component.name());
    }
}

