/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.Protobuf;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.project.Visibility;
import org.sonarqube.ws.WsComponents;

class ComponentDtoToWsComponent {
    private static final Set<String> QUALIFIERS_WITH_VISIBILITY = ImmutableSet.of((Object)"TRK", (Object)"VW", (Object)"APP");

    private ComponentDtoToWsComponent() {
    }

    static WsComponents.Component.Builder componentDtoToWsComponent(ComponentDto dto, OrganizationDto organizationDto, Optional<SnapshotDto> lastAnalysis) {
        Preconditions.checkArgument((boolean)Objects.equals(dto.getOrganizationUuid(), organizationDto.getUuid()), (String)"OrganizationUuid (%s) of ComponentDto to convert to Ws Component is not the same as the one (%s) of the specified OrganizationDto", (Object[])new Object[]{dto.getOrganizationUuid(), organizationDto.getUuid()});
        return ComponentDtoToWsComponent.componentDtoToWsComponent(dto, organizationDto.getKey(), lastAnalysis);
    }

    private static WsComponents.Component.Builder componentDtoToWsComponent(ComponentDto dto, String organizationDtoKey, Optional<SnapshotDto> lastAnalysis) {
        WsComponents.Component.Builder wsComponent = WsComponents.Component.newBuilder().setOrganization(organizationDtoKey).setId(dto.uuid()).setKey(dto.getKey()).setName(dto.name()).setQualifier(dto.qualifier());
        Protobuf.setNullable((Object)Strings.emptyToNull((String)dto.getBranch()), arg_0 -> ((WsComponents.Component.Builder)wsComponent).setBranch(arg_0));
        Protobuf.setNullable((Object)Strings.emptyToNull((String)dto.path()), arg_0 -> ((WsComponents.Component.Builder)wsComponent).setPath(arg_0));
        Protobuf.setNullable((Object)Strings.emptyToNull((String)dto.description()), arg_0 -> ((WsComponents.Component.Builder)wsComponent).setDescription(arg_0));
        Protobuf.setNullable((Object)Strings.emptyToNull((String)dto.language()), arg_0 -> ((WsComponents.Component.Builder)wsComponent).setLanguage(arg_0));
        ComponentDtoToWsComponent.setTags(dto, wsComponent);
        lastAnalysis.ifPresent(analysis -> {
            wsComponent.setAnalysisDate(DateUtils.formatDateTime((long)analysis.getCreatedAt()));
            Protobuf.setNullable((Object)analysis.getPeriodDate(), leak -> wsComponent.setLeakPeriodDate(DateUtils.formatDateTime((long)leak)));
            Protobuf.setNullable((Object)analysis.getVersion(), arg_0 -> ((WsComponents.Component.Builder)wsComponent).setVersion(arg_0));
        });
        if (QUALIFIERS_WITH_VISIBILITY.contains(dto.qualifier())) {
            wsComponent.setVisibility(Visibility.getLabel(dto.isPrivate()));
        }
        return wsComponent;
    }

    private static void setTags(ComponentDto dto, WsComponents.Component.Builder wsComponent) {
        if ("TRK".equals(dto.qualifier())) {
            wsComponent.getTagsBuilder().addAllTags((Iterable)dto.getTags());
        }
    }
}

