/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.index;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.server.component.index.ComponentHitsPerQualifier;

public class ComponentIndexResults {
    private final List<ComponentHitsPerQualifier> qualifiers;

    private ComponentIndexResults(Builder builder) {
        this.qualifiers = Objects.requireNonNull(builder.qualifiers);
    }

    public Stream<ComponentHitsPerQualifier> getQualifiers() {
        return this.qualifiers.stream();
    }

    public boolean isEmpty() {
        return this.qualifiers.isEmpty();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<ComponentHitsPerQualifier> qualifiers = Collections.emptyList();

        private Builder() {
        }

        public Builder setQualifiers(Stream<ComponentHitsPerQualifier> qualifiers) {
            this.qualifiers = qualifiers.collect(Collectors.toList());
            return this;
        }

        public ComponentIndexResults build() {
            return new ComponentIndexResults(this);
        }
    }
}

