/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.Set;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.ce.taskprocessor.CeTaskProcessor;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsCe;

public class TaskTypesAction
implements CeWsAction {
    private final Set<String> taskTypes;

    public TaskTypesAction(CeTaskProcessor[] taskProcessors) {
        ImmutableSet.Builder taskTypesBuilder = ImmutableSet.builder();
        for (CeTaskProcessor taskProcessor : taskProcessors) {
            taskTypesBuilder.addAll(taskProcessor.getHandledCeTaskTypes());
        }
        this.taskTypes = taskTypesBuilder.build();
    }

    @Override
    public void define(WebService.NewController controller) {
        controller.createAction("task_types").setDescription("List available task types").setResponseExample(this.getClass().getResource("task_types-example.json")).setSince("5.5").setInternal(true).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        WsCe.TaskTypesWsResponse taskTypesWsResponse = WsCe.TaskTypesWsResponse.newBuilder().addAllTaskTypes(this.taskTypes).build();
        WsUtils.writeProtobuf((Message)taskTypesWsResponse, request, response);
    }
}

