/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.common.base.Optional;
import com.google.protobuf.Message;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsCe;
import org.sonarqube.ws.client.ce.ActivityStatusWsRequest;

public class ActivityStatusAction
implements CeWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;

    public ActivityStatusAction(UserSession userSession, DbClient dbClient, ComponentFinder componentFinder) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
    }

    @Override
    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("activity_status").setDescription("Return CE activity related metrics.<br>Requires 'Administer System' permission or 'Administer' rights on the specified project.").setSince("5.5").setResponseExample(this.getClass().getResource("activity_status-example.json")).setInternal(true).setHandler((RequestHandler)this);
        action.createParam("componentId").setDescription("Id of the component (project) to filter on").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FL0");
        action.createParam("componentKey").setDescription("Key of the component (project) to filter on").setExampleValue((Object)"my_project");
        action.setChangelog(new Change[]{new Change("6.6", "New field 'inProgress' in response")});
    }

    public void handle(Request request, Response response) throws Exception {
        WsCe.ActivityStatusWsResponse activityStatusResponse = this.doHandle(ActivityStatusAction.toWsRequest(request));
        WsUtils.writeProtobuf((Message)activityStatusResponse, request, response);
    }

    private WsCe.ActivityStatusWsResponse doHandle(ActivityStatusWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional<ComponentDto> component = this.searchComponent(dbSession, request);
            String componentUuid = component.isPresent() ? ((ComponentDto)component.get()).uuid() : null;
            this.checkPermissions(component);
            int pendingCount = this.dbClient.ceQueueDao().countByStatusAndComponentUuid(dbSession, CeQueueDto.Status.PENDING, componentUuid);
            int inProgressCount = this.dbClient.ceQueueDao().countByStatusAndComponentUuid(dbSession, CeQueueDto.Status.IN_PROGRESS, componentUuid);
            int failingCount = this.dbClient.ceActivityDao().countLastByStatusAndComponentUuid(dbSession, CeActivityDto.Status.FAILED, componentUuid);
            WsCe.ActivityStatusWsResponse activityStatusWsResponse = WsCe.ActivityStatusWsResponse.newBuilder().setPending(pendingCount).setInProgress(inProgressCount).setFailing(failingCount).build();
            return activityStatusWsResponse;
        }
    }

    private Optional<ComponentDto> searchComponent(DbSession dbSession, ActivityStatusWsRequest request) {
        ComponentDto component = null;
        if (ActivityStatusAction.hasComponentInRequest(request)) {
            component = this.componentFinder.getByUuidOrKey(dbSession, request.getComponentId(), request.getComponentKey(), ComponentFinder.ParamNames.COMPONENT_ID_AND_KEY);
        }
        return Optional.fromNullable(component);
    }

    private void checkPermissions(Optional<ComponentDto> component) {
        if (component.isPresent()) {
            this.userSession.checkComponentPermission("admin", (ComponentDto)component.get());
        } else {
            this.userSession.checkIsSystemAdministrator();
        }
    }

    private static boolean hasComponentInRequest(ActivityStatusWsRequest request) {
        return request.getComponentId() != null || request.getComponentKey() != null;
    }

    private static ActivityStatusWsRequest toWsRequest(Request request) {
        return ActivityStatusWsRequest.newBuilder().setComponentId(request.param("componentId")).setComponentKey(request.param("componentKey")).build();
    }
}

