/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication.ws;

import com.google.common.io.Resources;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.api.web.ServletFilter;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.BasicAuthenticator;
import org.sonar.server.authentication.JwtHttpHandler;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.authentication.ws.AuthenticationWsAction;
import org.sonar.server.ws.ServletFilterHandler;

public class ValidateAction
extends ServletFilter
implements AuthenticationWsAction {
    private static final String VALIDATE_ACTION = "validate";
    public static final String VALIDATE_URL = "/api/authentication/validate";
    private final Configuration config;
    private final JwtHttpHandler jwtHttpHandler;
    private final BasicAuthenticator basicAuthenticator;

    public ValidateAction(Configuration config, BasicAuthenticator basicAuthenticator, JwtHttpHandler jwtHttpHandler) {
        this.config = config;
        this.basicAuthenticator = basicAuthenticator;
        this.jwtHttpHandler = jwtHttpHandler;
    }

    @Override
    public void define(WebService.NewController controller) {
        controller.createAction(VALIDATE_ACTION).setDescription("Check credentials.").setSince("3.3").setHandler(ServletFilterHandler.INSTANCE).setResponseExample(Resources.getResource(this.getClass(), (String)"example-validate.json"));
    }

    public ServletFilter.UrlPattern doGetPattern() {
        return ServletFilter.UrlPattern.create((String)VALIDATE_URL);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean isAuthenticated = this.authenticate(request, response);
        response.setContentType("application/json");
        try (JsonWriter jsonWriter = JsonWriter.of((Writer)response.getWriter());){
            jsonWriter.beginObject();
            jsonWriter.prop("valid", isAuthenticated);
            jsonWriter.endObject();
        }
    }

    private boolean authenticate(HttpServletRequest request, HttpServletResponse response) {
        try {
            Optional<UserDto> user = this.jwtHttpHandler.validateToken(request, response);
            if (user.isPresent()) {
                return true;
            }
            user = this.basicAuthenticator.authenticate(request);
            if (user.isPresent()) {
                return true;
            }
            return this.config.getBoolean("sonar.forceAuthentication").orElse(false) == false;
        }
        catch (AuthenticationException e) {
            return false;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

