/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserGroupDto;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.organization.DefaultOrganization;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.user.ExternalIdentity;
import org.sonar.server.user.NewUser;
import org.sonar.server.user.UpdateUser;
import org.sonar.server.user.UserUpdater;
import org.sonar.server.usergroups.DefaultGroupFinder;

public class UserIdentityAuthenticator {
    private static final Logger LOGGER = Loggers.get(UserIdentityAuthenticator.class);
    private final DbClient dbClient;
    private final UserUpdater userUpdater;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final OrganizationFlags organizationFlags;
    private final DefaultGroupFinder defaultGroupFinder;

    public UserIdentityAuthenticator(DbClient dbClient, UserUpdater userUpdater, DefaultOrganizationProvider defaultOrganizationProvider, OrganizationFlags organizationFlags, DefaultGroupFinder defaultGroupFinder) {
        this.dbClient = dbClient;
        this.userUpdater = userUpdater;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.organizationFlags = organizationFlags;
        this.defaultGroupFinder = defaultGroupFinder;
    }

    public UserDto authenticate(UserIdentity user, IdentityProvider provider, AuthenticationEvent.Source source) {
        return this.register(user, provider, source);
    }

    private UserDto register(UserIdentity user, IdentityProvider provider, AuthenticationEvent.Source source) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String userLogin = user.getLogin();
            UserDto userDto = this.dbClient.userDao().selectByLogin(dbSession, userLogin);
            if (userDto != null && userDto.isActive()) {
                this.registerExistingUser(dbSession, userDto, user, provider);
                UserDto userDto2 = userDto;
                return userDto2;
            }
            UserDto userDto3 = this.registerNewUser(dbSession, user, provider, source);
            return userDto3;
        }
    }

    private UserDto registerNewUser(DbSession dbSession, UserIdentity identity, IdentityProvider provider, AuthenticationEvent.Source source) {
        if (!provider.allowsUsersToSignUp()) {
            throw AuthenticationException.newBuilder().setSource(source).setLogin(identity.getLogin()).setMessage(String.format("User signup disabled for provider '%s'", provider.getKey())).setPublicMessage(String.format("'%s' users are not allowed to sign up", provider.getKey())).build();
        }
        String email = identity.getEmail();
        if (email != null && this.dbClient.userDao().doesEmailExist(dbSession, email)) {
            throw AuthenticationException.newBuilder().setSource(source).setLogin(identity.getLogin()).setMessage(String.format("Email '%s' is already used", email)).setPublicMessage(String.format("You can't sign up because email '%s' is already used by an existing user. This means that you probably already registered with another account.", email)).build();
        }
        String userLogin = identity.getLogin();
        return this.userUpdater.createAndCommit(dbSession, NewUser.builder().setLogin(userLogin).setEmail(identity.getEmail()).setName(identity.getName()).setExternalIdentity(new ExternalIdentity(provider.getKey(), identity.getProviderLogin())).build(), u -> this.syncGroups(dbSession, identity, (UserDto)u));
    }

    private void registerExistingUser(DbSession dbSession, UserDto userDto, UserIdentity identity, IdentityProvider provider) {
        UpdateUser update = UpdateUser.create(userDto.getLogin()).setEmail(identity.getEmail()).setName(identity.getName()).setExternalIdentity(new ExternalIdentity(provider.getKey(), identity.getProviderLogin()));
        this.userUpdater.updateAndCommit(dbSession, update, u -> this.syncGroups(dbSession, identity, (UserDto)u));
    }

    private void syncGroups(DbSession dbSession, UserIdentity userIdentity, UserDto userDto) {
        if (!userIdentity.shouldSyncGroups()) {
            return;
        }
        String userLogin = userIdentity.getLogin();
        HashSet userGroups = new HashSet(this.dbClient.groupMembershipDao().selectGroupsByLogins(dbSession, Collections.singletonList(userLogin)).get((Object)userLogin));
        Set identityGroups = userIdentity.getGroups();
        LOGGER.debug("List of groups returned by the identity provider '{}'", (Object)identityGroups);
        Sets.SetView groupsToAdd = Sets.difference((Set)identityGroups, userGroups);
        Sets.SetView groupsToRemove = Sets.difference(userGroups, (Set)identityGroups);
        ArrayList allGroups = new ArrayList(groupsToAdd);
        allGroups.addAll(groupsToRemove);
        DefaultOrganization defaultOrganization = this.defaultOrganizationProvider.get();
        Map groupsByName = (Map)this.dbClient.groupDao().selectByNames(dbSession, defaultOrganization.getUuid(), allGroups).stream().collect(MoreCollectors.uniqueIndex(GroupDto::getName));
        this.addGroups(dbSession, userDto, (Collection<String>)groupsToAdd, groupsByName);
        this.removeGroups(dbSession, userDto, (Collection<String>)groupsToRemove, groupsByName);
    }

    private void addGroups(DbSession dbSession, UserDto userDto, Collection<String> groupsToAdd, Map<String, GroupDto> groupsByName) {
        groupsToAdd.stream().map(groupsByName::get).filter(Objects::nonNull).forEach(groupDto -> {
            LOGGER.debug("Adding group '{}' to user '{}'", (Object)groupDto.getName(), (Object)userDto.getLogin());
            this.dbClient.userGroupDao().insert(dbSession, new UserGroupDto().setGroupId(groupDto.getId().intValue()).setUserId(userDto.getId().intValue()));
        });
    }

    private void removeGroups(DbSession dbSession, UserDto userDto, Collection<String> groupsToRemove, Map<String, GroupDto> groupsByName) {
        Optional<GroupDto> defaultGroup = this.getDefaultGroup(dbSession);
        groupsToRemove.stream().map(groupsByName::get).filter(Objects::nonNull).filter(group -> !defaultGroup.isPresent() || !group.getId().equals(((GroupDto)defaultGroup.get()).getId())).forEach(groupDto -> {
            LOGGER.debug("Removing group '{}' from user '{}'", (Object)groupDto.getName(), (Object)userDto.getLogin());
            this.dbClient.userGroupDao().delete(dbSession, groupDto.getId().intValue(), userDto.getId().intValue());
        });
    }

    private Optional<GroupDto> getDefaultGroup(DbSession dbSession) {
        return this.organizationFlags.isEnabled(dbSession) ? Optional.empty() : Optional.of(this.defaultGroupFinder.findDefaultGroup(dbSession, this.defaultOrganizationProvider.get().getUuid()));
    }
}

