/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.authentication.Display;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.JwtHttpHandler;
import org.sonar.server.authentication.UserIdentityAuthenticator;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.exceptions.BadRequestException;

public class SsoAuthenticator
implements Startable {
    private static final Logger LOG = Loggers.get(SsoAuthenticator.class);
    private static final Splitter COMA_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private static final String ENABLE_PARAM = "sonar.web.sso.enable";
    private static final String LOGIN_HEADER_PARAM = "sonar.web.sso.loginHeader";
    private static final String LOGIN_HEADER_DEFAULT_VALUE = "X-Forwarded-Login";
    private static final String NAME_HEADER_PARAM = "sonar.web.sso.nameHeader";
    private static final String NAME_HEADER_DEFAULT_VALUE = "X-Forwarded-Name";
    private static final String EMAIL_HEADER_PARAM = "sonar.web.sso.emailHeader";
    private static final String EMAIL_HEADER_DEFAULT_VALUE = "X-Forwarded-Email";
    private static final String GROUPS_HEADER_PARAM = "sonar.web.sso.groupsHeader";
    private static final String GROUPS_HEADER_DEFAULT_VALUE = "X-Forwarded-Groups";
    private static final String REFRESH_INTERVAL_PARAM = "sonar.web.sso.refreshIntervalInMinutes";
    private static final String REFRESH_INTERVAL_DEFAULT_VALUE = "5";
    private static final String LAST_REFRESH_TIME_TOKEN_PARAM = "ssoLastRefreshTime";
    private static final Map<String, String> DEFAULT_VALUES_BY_SETTING_KEYS = ImmutableMap.of((Object)"sonar.web.sso.loginHeader", (Object)"X-Forwarded-Login", (Object)"sonar.web.sso.nameHeader", (Object)"X-Forwarded-Name", (Object)"sonar.web.sso.emailHeader", (Object)"X-Forwarded-Email", (Object)"sonar.web.sso.groupsHeader", (Object)"X-Forwarded-Groups", (Object)"sonar.web.sso.refreshIntervalInMinutes", (Object)"5");
    private final System2 system2;
    private final Configuration config;
    private final UserIdentityAuthenticator userIdentityAuthenticator;
    private final JwtHttpHandler jwtHttpHandler;
    private final AuthenticationEvent authenticationEvent;
    private boolean enabled = false;
    private Map<String, String> settingsByKey = new HashMap<String, String>();

    public SsoAuthenticator(System2 system2, Configuration config, UserIdentityAuthenticator userIdentityAuthenticator, JwtHttpHandler jwtHttpHandler, AuthenticationEvent authenticationEvent) {
        this.system2 = system2;
        this.config = config;
        this.userIdentityAuthenticator = userIdentityAuthenticator;
        this.jwtHttpHandler = jwtHttpHandler;
        this.authenticationEvent = authenticationEvent;
    }

    public void start() {
        if (this.config.getBoolean(ENABLE_PARAM).orElse(false).booleanValue()) {
            LOG.info("SSO Authentication enabled");
            this.enabled = true;
            DEFAULT_VALUES_BY_SETTING_KEYS.entrySet().forEach(entry -> this.settingsByKey.put((String)entry.getKey(), this.config.get((String)entry.getKey()).orElse(DEFAULT_VALUES_BY_SETTING_KEYS.get(entry.getKey()))));
        }
    }

    public void stop() {
    }

    public Optional<UserDto> authenticate(HttpServletRequest request, HttpServletResponse response) {
        try {
            return this.doAuthenticate(request, response);
        }
        catch (BadRequestException e) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.sso()).setMessage(e.getMessage()).build();
        }
    }

    private Optional<UserDto> doAuthenticate(HttpServletRequest request, HttpServletResponse response) {
        if (!this.enabled) {
            return Optional.empty();
        }
        Map<String, String> headerValuesByNames = SsoAuthenticator.getHeaders(request);
        String login = this.getHeaderValue(headerValuesByNames, LOGIN_HEADER_PARAM);
        if (login == null) {
            return Optional.empty();
        }
        Optional<UserDto> user = this.getUserFromToken(request, response);
        if (user.isPresent() && login.equals(user.get().getLogin())) {
            return user;
        }
        UserDto userDto = this.doAuthenticate(headerValuesByNames, login);
        this.jwtHttpHandler.generateToken(userDto, (Map<String, Object>)ImmutableMap.of((Object)LAST_REFRESH_TIME_TOKEN_PARAM, (Object)this.system2.now()), request, response);
        this.authenticationEvent.loginSuccess(request, userDto.getLogin(), AuthenticationEvent.Source.sso());
        return Optional.of(userDto);
    }

    private Optional<UserDto> getUserFromToken(HttpServletRequest request, HttpServletResponse response) {
        Optional<JwtHttpHandler.Token> token = this.jwtHttpHandler.getToken(request, response);
        if (!token.isPresent()) {
            return Optional.empty();
        }
        Date now = new Date(this.system2.now());
        int refreshIntervalInMinutes = Integer.parseInt(this.settingsByKey.get(REFRESH_INTERVAL_PARAM));
        Long lastFreshTime = (Long)token.get().getProperties().get(LAST_REFRESH_TIME_TOKEN_PARAM);
        if (lastFreshTime == null || now.after(DateUtils.addMinutes((Date)new Date(lastFreshTime), (int)refreshIntervalInMinutes))) {
            return Optional.empty();
        }
        return Optional.of(token.get().getUserDto());
    }

    private UserDto doAuthenticate(Map<String, String> headerValuesByNames, String login) {
        String name = this.getHeaderValue(headerValuesByNames, NAME_HEADER_PARAM);
        String email = this.getHeaderValue(headerValuesByNames, EMAIL_HEADER_PARAM);
        UserIdentity.Builder userIdentityBuilder = UserIdentity.builder().setLogin(login).setName(name == null ? login : name).setEmail(email).setProviderLogin(login);
        if (this.hasHeader(headerValuesByNames, GROUPS_HEADER_PARAM)) {
            String groupsValue = this.getHeaderValue(headerValuesByNames, GROUPS_HEADER_PARAM);
            userIdentityBuilder.setGroups((Set)(groupsValue == null ? Collections.emptySet() : new HashSet(COMA_SPLITTER.splitToList((CharSequence)groupsValue))));
        }
        return this.userIdentityAuthenticator.authenticate(userIdentityBuilder.build(), new SsoIdentityProvider(), AuthenticationEvent.Source.sso());
    }

    @CheckForNull
    private String getHeaderValue(Map<String, String> headerValuesByNames, String settingKey) {
        return headerValuesByNames.get(this.settingsByKey.get(settingKey).toLowerCase(Locale.ENGLISH));
    }

    private static Map<String, String> getHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Collections.list(request.getHeaderNames()).forEach(header -> headers.put(header.toLowerCase(Locale.ENGLISH), request.getHeader(header)));
        return headers;
    }

    private boolean hasHeader(Map<String, String> headerValuesByNames, String settingKey) {
        return headerValuesByNames.keySet().contains(this.settingsByKey.get(settingKey).toLowerCase(Locale.ENGLISH));
    }

    private static class SsoIdentityProvider
    implements IdentityProvider {
        private SsoIdentityProvider() {
        }

        public String getKey() {
            return "sonarqube";
        }

        public String getName() {
            return this.getKey();
        }

        public Display getDisplay() {
            return null;
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean allowsUsersToSignUp() {
            return true;
        }
    }
}

