/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scm.ScmChangedFiles;
import org.sonar.scanner.scm.ScmConfiguration;

public class ScmChangedFilesProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(ScmChangedFilesProvider.class);
    private static final String LOG_MSG = "SCM collecting changed files in the branch";
    private ScmChangedFiles scmBranchChangedFiles;

    public ScmChangedFiles provide(@org.picocontainer.annotations.Nullable ScmConfiguration scmConfiguration, BranchConfiguration branchConfiguration, InputModuleHierarchy inputModuleHierarchy) {
        if (this.scmBranchChangedFiles == null) {
            if (scmConfiguration == null) {
                this.scmBranchChangedFiles = new ScmChangedFiles(null);
            } else {
                Path rootBaseDir = inputModuleHierarchy.root().getBaseDir();
                Collection<Path> changedFiles = ScmChangedFilesProvider.loadChangedFilesIfNeeded(scmConfiguration, branchConfiguration, rootBaseDir);
                ScmChangedFilesProvider.validatePaths(changedFiles);
                this.scmBranchChangedFiles = new ScmChangedFiles(changedFiles);
            }
        }
        return this.scmBranchChangedFiles;
    }

    private static void validatePaths(@Nullable Collection<Path> paths) {
        if (paths != null && paths.stream().anyMatch(p -> !p.isAbsolute())) {
            throw new IllegalStateException("SCM provider returned a changed file with a relative path but paths must be absolute. Please fix the provider.");
        }
    }

    @CheckForNull
    private static Collection<Path> loadChangedFilesIfNeeded(ScmConfiguration scmConfiguration, BranchConfiguration branchConfiguration, Path rootBaseDir) {
        if (branchConfiguration.isShortLivingBranch() && branchConfiguration.branchTarget() != null) {
            ScmProvider scmProvider = scmConfiguration.provider();
            if (scmProvider != null) {
                Profiler profiler = Profiler.create((Logger)LOG).startInfo(LOG_MSG);
                Set changedFiles = scmProvider.branchChangedFiles(branchConfiguration.branchTarget(), rootBaseDir);
                profiler.stopInfo();
                if (changedFiles != null) {
                    LOG.debug("SCM reported {} {} changed in the branch", (Object)changedFiles.size(), (Object)ScmChangedFilesProvider.pluralize("file", changedFiles.size()));
                    return changedFiles;
                }
            }
            LOG.debug("SCM information about changed files in the branch is not available");
        }
        return null;
    }

    private static String pluralize(String str, int i) {
        if (i == 1) {
            return str;
        }
        return str + "s";
    }
}

