/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import com.google.common.annotations.VisibleForTesting;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.scanner.analysis.DefaultAnalysisMode;
import org.sonar.scanner.scan.filesystem.ModuleFileSystemInitializer;
import org.sonar.scanner.scan.filesystem.ModuleInputComponentStore;
import org.sonar.scanner.scan.filesystem.SameInputFilePredicate;
import org.sonar.scanner.scan.filesystem.StatusDetection;

public class DefaultModuleFileSystem
extends DefaultFileSystem {
    public DefaultModuleFileSystem(ModuleInputComponentStore moduleInputFileCache, DefaultInputModule module, ModuleFileSystemInitializer initializer, DefaultAnalysisMode mode, StatusDetection statusDetection) {
        super(module.getBaseDir(), (DefaultFileSystem.Cache)moduleInputFileCache);
        this.setFields(module, initializer, mode, statusDetection);
    }

    @VisibleForTesting
    public DefaultModuleFileSystem(DefaultInputModule module, ModuleFileSystemInitializer initializer, DefaultAnalysisMode mode, StatusDetection statusDetection) {
        super(module.getBaseDir());
        this.setFields(module, initializer, mode, statusDetection);
    }

    private void setFields(DefaultInputModule module, ModuleFileSystemInitializer initializer, DefaultAnalysisMode mode, StatusDetection statusDetection) {
        this.setWorkDir(module.getWorkDir());
        this.setEncoding(initializer.defaultEncoding());
        if (!mode.scanAllFiles()) {
            this.setDefaultPredicate(p -> new SameInputFilePredicate((FilePredicate)p, statusDetection, module.definition().getKeyWithBranch()));
        }
    }
}

