/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import org.apache.commons.io.ByteOrderMark;
import org.sonar.scanner.scan.filesystem.CharsetValidation;
import org.sonar.scanner.scan.filesystem.MetadataGenerator;

public class ByteCharsetDetector {
    private static final ByteOrderMark[] boms = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE};
    private final Charset userConfiguration;
    private final CharsetValidation validator;

    public ByteCharsetDetector(CharsetValidation validator, Charset userConfiguration) {
        this.validator = validator;
        this.userConfiguration = userConfiguration;
    }

    @CheckForNull
    public Charset detect(byte[] buf) {
        CharsetValidation.Result utf8Result = this.validator.isUTF8(buf, true);
        if (utf8Result.valid() == CharsetValidation.Validation.YES) {
            return utf8Result.charset();
        }
        if (utf8Result.valid() == CharsetValidation.Validation.MAYBE) {
            return this.detectAscii(buf);
        }
        CharsetValidation.Result utf16 = this.validator.isUTF16(buf, true);
        if (utf16.valid() == CharsetValidation.Validation.YES && this.validator.isValidUTF16(buf, StandardCharsets.UTF_16LE.equals(utf16.charset()))) {
            return utf16.charset();
        }
        Charset c = this.userConfiguration;
        if (!(StandardCharsets.UTF_8.equals(c) || ByteCharsetDetector.isUtf16(c) && utf16.valid() != CharsetValidation.Validation.MAYBE || !this.validator.tryDecode(buf, c))) {
            return c;
        }
        CharsetValidation.Result windows1252 = this.validator.isValidWindows1252(buf);
        if (windows1252.valid() == CharsetValidation.Validation.MAYBE) {
            return windows1252.charset();
        }
        return null;
    }

    private Charset detectAscii(byte[] buf) {
        if (!ByteCharsetDetector.isUtf16Or32(this.userConfiguration) && this.validator.tryDecode(buf, this.userConfiguration)) {
            return this.userConfiguration;
        }
        return null;
    }

    private static boolean isUtf16(Charset charset) {
        return StandardCharsets.UTF_16.equals(charset) || StandardCharsets.UTF_16BE.equals(charset) || StandardCharsets.UTF_16LE.equals(charset);
    }

    private static boolean isUtf16Or32(Charset charset) {
        return ByteCharsetDetector.isUtf16(charset) || MetadataGenerator.UTF_32BE.equals(charset) || MetadataGenerator.UTF_32LE.equals(charset);
    }

    @CheckForNull
    public ByteOrderMark detectBOM(byte[] buffer) {
        return Arrays.stream(boms).filter(b -> ByteCharsetDetector.isBom(b, buffer)).findAny().orElse(null);
    }

    private static boolean isBom(ByteOrderMark bom, byte[] buffer) {
        if (buffer.length < bom.length()) {
            return false;
        }
        for (int i = 0; i < bom.length(); ++i) {
            if ((byte)bom.get(i) == buffer[i]) continue;
            return false;
        }
        return true;
    }
}

