/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.branch;

import java.util.Collections;
import org.picocontainer.annotations.Nullable;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.scan.branch.ProjectBranches;
import org.sonar.scanner.scan.branch.ProjectBranchesLoader;

public class ProjectBranchesProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(ProjectBranchesProvider.class);
    private static final String LOG_MSG = "Load project branches";
    private ProjectBranches branches = null;

    public ProjectBranches provide(@Nullable ProjectBranchesLoader loader, ProjectKey projectKey, GlobalConfiguration settings) {
        if (this.branches == null) {
            if (loader == null || !settings.get("sonar.branch.name").isPresent()) {
                this.branches = new ProjectBranches(Collections.emptyList());
            } else {
                Profiler profiler = Profiler.create((Logger)LOG).startInfo(LOG_MSG);
                this.branches = loader.load(projectKey.get());
                profiler.stopInfo();
            }
        }
        return this.branches;
    }
}

