/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.utils.MessageException;
import org.sonar.core.component.ComponentKeys;
import org.sonar.scanner.scan.branch.BranchParamsValidator;
import org.sonar.scanner.scan.branch.DefaultBranchParamsValidator;

public class ProjectReactorValidator {
    private final AnalysisMode mode;
    private final BranchParamsValidator branchParamsValidator;

    public ProjectReactorValidator(AnalysisMode mode, BranchParamsValidator branchParamsValidator) {
        this.mode = mode;
        this.branchParamsValidator = branchParamsValidator;
    }

    public ProjectReactorValidator(AnalysisMode mode) {
        this(mode, new DefaultBranchParamsValidator());
    }

    public void validate(ProjectReactor reactor) {
        ArrayList<String> validationMessages = new ArrayList<String>();
        for (ProjectDefinition moduleDef : reactor.getProjects()) {
            if (this.mode.isIssues()) {
                ProjectReactorValidator.validateModuleIssuesMode(moduleDef, validationMessages);
                continue;
            }
            ProjectReactorValidator.validateModule(moduleDef, validationMessages);
        }
        String deprecatedBranchName = reactor.getRoot().getBranch();
        this.branchParamsValidator.validate(validationMessages, deprecatedBranchName);
        ProjectReactorValidator.validateBranch(validationMessages, deprecatedBranchName);
        if (!validationMessages.isEmpty()) {
            throw MessageException.of((String)("Validation of project reactor failed:\n  o " + Joiner.on((String)"\n  o ").join(validationMessages)));
        }
    }

    private static void validateModuleIssuesMode(ProjectDefinition moduleDef, List<String> validationMessages) {
        if (!ComponentKeys.isValidModuleKeyIssuesMode((String)moduleDef.getKey())) {
            validationMessages.add(String.format("\"%s\" is not a valid project or module key. Allowed characters in issues mode are alphanumeric, '-', '_', '.', '/' and ':', with at least one non-digit.", moduleDef.getKey()));
        }
    }

    private static void validateModule(ProjectDefinition moduleDef, List<String> validationMessages) {
        if (!ComponentKeys.isValidModuleKey((String)moduleDef.getKey())) {
            validationMessages.add(String.format("\"%s\" is not a valid project or module key. Allowed characters are alphanumeric, '-', '_', '.' and ':', with at least one non-digit.", moduleDef.getKey()));
        }
    }

    private static void validateBranch(List<String> validationMessages, @Nullable String branch) {
        if (StringUtils.isNotEmpty((String)branch) && !ComponentKeys.isValidBranch((String)branch)) {
            validationMessages.add(String.format("\"%s\" is not a valid branch name. Allowed characters are alphanumeric, '-', '_', '.' and '/'.", branch));
        }
    }
}

