/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.report.AnalysisContextReportPublisher;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.scan.ModuleSettings;

public class ModuleSettingsProvider
extends ProviderAdapter {
    private ModuleSettings projectSettings;

    public ModuleSettings provide(GlobalConfiguration globalSettings, DefaultInputModule module, ProjectRepositories projectRepos, GlobalAnalysisMode analysisMode, AnalysisContextReportPublisher contextReportPublisher) {
        if (this.projectSettings == null) {
            LinkedHashMap<String, String> settings = new LinkedHashMap<String, String>();
            settings.putAll(globalSettings.getProperties());
            settings.putAll(ModuleSettingsProvider.addServerSidePropertiesIfModuleExists(projectRepos, module.definition()));
            ModuleSettingsProvider.addScannerSideProperties(settings, module.definition());
            contextReportPublisher.dumpModuleSettings(module);
            this.projectSettings = new ModuleSettings(globalSettings.getDefinitions(), globalSettings.getEncryption(), analysisMode, settings);
        }
        return this.projectSettings;
    }

    private static Map<String, String> addServerSidePropertiesIfModuleExists(ProjectRepositories projectRepos, ProjectDefinition def) {
        if (projectRepos.moduleExists(def.getKeyWithBranch())) {
            return projectRepos.settings(def.getKeyWithBranch());
        }
        ProjectDefinition parentDef = def.getParent();
        if (parentDef != null) {
            return ModuleSettingsProvider.addServerSidePropertiesIfModuleExists(projectRepos, parentDef);
        }
        return Collections.emptyMap();
    }

    private static void addScannerSideProperties(Map<String, String> settings, ProjectDefinition project) {
        List<ProjectDefinition> orderedProjects = ModuleSettingsProvider.getTopDownParentProjects(project);
        for (ProjectDefinition p : orderedProjects) {
            settings.putAll(p.properties());
        }
    }

    static List<ProjectDefinition> getTopDownParentProjects(ProjectDefinition project) {
        ArrayList<ProjectDefinition> result = new ArrayList<ProjectDefinition>();
        for (ProjectDefinition p = project; p != null; p = p.getParent()) {
            result.add(0, p);
        }
        return result;
    }
}

