/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.FileMetadata;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.resources.Project;
import org.sonar.api.scan.filesystem.FileExclusions;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.scanner.DefaultFileLinesContextFactory;
import org.sonar.scanner.bootstrap.ExtensionInstaller;
import org.sonar.scanner.bootstrap.ExtensionUtils;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.ScannerExtensionDictionnary;
import org.sonar.scanner.deprecated.DeprecatedSensorContext;
import org.sonar.scanner.deprecated.perspectives.ScannerPerspectives;
import org.sonar.scanner.events.EventBus;
import org.sonar.scanner.index.DefaultIndex;
import org.sonar.scanner.issue.IssuableFactory;
import org.sonar.scanner.issue.IssueFilters;
import org.sonar.scanner.issue.ModuleIssues;
import org.sonar.scanner.issue.ignore.EnforceIssuesFilter;
import org.sonar.scanner.issue.ignore.IgnoreIssuesFilter;
import org.sonar.scanner.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonar.scanner.issue.ignore.pattern.IssueInclusionPatternInitializer;
import org.sonar.scanner.issue.ignore.pattern.PatternMatcher;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.scanner.phases.AbstractPhaseExecutor;
import org.sonar.scanner.phases.CoverageExclusions;
import org.sonar.scanner.phases.InitializersExecutor;
import org.sonar.scanner.phases.IssuesPhaseExecutor;
import org.sonar.scanner.phases.PostJobsExecutor;
import org.sonar.scanner.phases.PublishPhaseExecutor;
import org.sonar.scanner.phases.SensorsExecutor;
import org.sonar.scanner.postjob.DefaultPostJobContext;
import org.sonar.scanner.postjob.PostJobOptimizer;
import org.sonar.scanner.rule.QProfileVerifier;
import org.sonar.scanner.rule.RuleFinderCompatibility;
import org.sonar.scanner.rule.RulesProfileProvider;
import org.sonar.scanner.scan.ModuleSettingsProvider;
import org.sonar.scanner.scan.MutableModuleSettings;
import org.sonar.scanner.scan.ProjectScanContainer;
import org.sonar.scanner.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.scanner.scan.filesystem.ExclusionFilters;
import org.sonar.scanner.scan.filesystem.FileIndexer;
import org.sonar.scanner.scan.filesystem.InputFileBuilder;
import org.sonar.scanner.scan.filesystem.LanguageDetection;
import org.sonar.scanner.scan.filesystem.MetadataGenerator;
import org.sonar.scanner.scan.filesystem.ModuleFileSystemInitializer;
import org.sonar.scanner.scan.filesystem.ModuleInputComponentStore;
import org.sonar.scanner.scan.report.IssuesReports;
import org.sonar.scanner.sensor.DefaultSensorStorage;
import org.sonar.scanner.sensor.SensorOptimizer;
import org.sonar.scanner.source.HighlightableBuilder;
import org.sonar.scanner.source.SymbolizableBuilder;

public class ModuleScanContainer
extends ComponentContainer {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleScanContainer.class);
    private final DefaultInputModule module;
    private final GlobalAnalysisMode analysisMode;

    public ModuleScanContainer(ProjectScanContainer parent, DefaultInputModule module, GlobalAnalysisMode analysisMode) {
        super((ComponentContainer)parent);
        this.module = module;
        this.analysisMode = analysisMode;
    }

    protected void doBeforeStart() {
        LOG.info("-------------  Scan {}", (Object)this.module.definition().getName());
        this.addCoreComponents();
        this.addExtensions();
    }

    private void addCoreComponents() {
        this.add(new Object[]{this.module.definition(), new Project(this.module), this.module, MutableModuleSettings.class, new ModuleSettingsProvider()});
        if (this.analysisMode.isIssues()) {
            this.add(new Object[]{IssuesPhaseExecutor.class, IssuesReports.class});
        } else {
            this.add(new Object[]{PublishPhaseExecutor.class});
        }
        this.add(new Object[]{EventBus.class, RuleFinderCompatibility.class, PostJobsExecutor.class, SensorsExecutor.class, InitializersExecutor.class, ModuleInputComponentStore.class, FileExclusions.class, ExclusionFilters.class, MetadataGenerator.class, FileMetadata.class, LanguageDetection.class, FileIndexer.class, InputFileBuilder.class, DefaultModuleFileSystem.class, ModuleFileSystemInitializer.class, QProfileVerifier.class, SensorOptimizer.class, PostJobOptimizer.class, DefaultPostJobContext.class, DefaultSensorStorage.class, DeprecatedSensorContext.class, ScannerExtensionDictionnary.class, IssueFilters.class, CoverageExclusions.class, SensorStrategy.class, new RulesProfileProvider(), CheckFactory.class, IssuableFactory.class, ModuleIssues.class, NoSonarFilter.class, IssueInclusionPatternInitializer.class, IssueExclusionPatternInitializer.class, PatternMatcher.class, IssueExclusionsLoader.class, EnforceIssuesFilter.class, IgnoreIssuesFilter.class, ScannerPerspectives.class, HighlightableBuilder.class, SymbolizableBuilder.class, DefaultFileLinesContextFactory.class});
    }

    private void addExtensions() {
        ExtensionInstaller installer = (ExtensionInstaller)this.getComponentByType(ExtensionInstaller.class);
        installer.install(this, e -> ExtensionUtils.isScannerSide(e) && ExtensionUtils.isInstantiationStrategy(e, "PER_PROJECT"));
    }

    protected void doAfterStart() {
        DefaultIndex index = (DefaultIndex)this.getComponentByType(DefaultIndex.class);
        index.setCurrentStorage((DefaultSensorStorage)this.getComponentByType(DefaultSensorStorage.class));
        ((AbstractPhaseExecutor)this.getComponentByType(AbstractPhaseExecutor.class)).execute(this.module);
    }
}

