/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.config.Configuration;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;
import org.sonar.scanner.rule.ModuleQProfiles;
import org.sonar.scanner.rule.QProfile;
import org.sonar.scanner.rule.RulesProfileWrapper;

public class RulesProfileProvider
extends ProviderAdapter {
    private RulesProfile singleton = null;

    public RulesProfile provide(ModuleQProfiles qProfiles, ActiveRules activeRules, Configuration settings) {
        if (this.singleton == null) {
            String lang = settings.get("sonar.language").orElse(null);
            this.singleton = StringUtils.isNotBlank((String)lang) ? RulesProfileProvider.loadSingleLanguageProfile(qProfiles, activeRules, lang) : RulesProfileProvider.loadProfiles(qProfiles, activeRules);
        }
        return this.singleton;
    }

    private static RulesProfile loadSingleLanguageProfile(ModuleQProfiles qProfiles, ActiveRules activeRules, String language) {
        QProfile qProfile = qProfiles.findByLanguage(language);
        if (qProfile != null) {
            return new RulesProfileWrapper(RulesProfileProvider.select(qProfile, activeRules));
        }
        return new RulesProfileWrapper(new ArrayList<RulesProfile>());
    }

    private static RulesProfile loadProfiles(ModuleQProfiles qProfiles, ActiveRules activeRules) {
        Collection<QProfile> profiles = qProfiles.findAll();
        ArrayList<RulesProfile> dtos = new ArrayList<RulesProfile>(profiles.size());
        for (QProfile qProfile : profiles) {
            dtos.add(RulesProfileProvider.select(qProfile, activeRules));
        }
        return new RulesProfileWrapper(dtos);
    }

    private static RulesProfile select(QProfile qProfile, ActiveRules activeRules) {
        RulesProfile deprecatedProfile = new RulesProfile();
        deprecatedProfile.setName(qProfile.getName());
        deprecatedProfile.setLanguage(qProfile.getLanguage());
        for (ActiveRule activeRule : activeRules.findByLanguage(qProfile.getLanguage())) {
            Rule rule = Rule.create((String)activeRule.ruleKey().repository(), (String)activeRule.ruleKey().rule());
            rule.setConfigKey(activeRule.internalKey());
            if (activeRule.templateRuleKey() != null) {
                rule.setTemplate(Rule.create((String)activeRule.ruleKey().repository(), (String)activeRule.templateRuleKey()));
            }
            org.sonar.api.rules.ActiveRule deprecatedActiveRule = deprecatedProfile.activateRule(rule, RulePriority.valueOf((String)activeRule.severity()));
            for (Map.Entry param : activeRule.params().entrySet()) {
                rule.createParameter((String)param.getKey());
                deprecatedActiveRule.setParameter((String)param.getKey(), (String)param.getValue());
            }
        }
        return deprecatedProfile;
    }
}

