/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.DateUtils;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonar.scanner.rule.ActiveRulesLoader;
import org.sonar.scanner.rule.LoadedActiveRule;
import org.sonar.scanner.util.ScannerUtils;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.WsRequest;

public class DefaultActiveRulesLoader
implements ActiveRulesLoader {
    private static final String RULES_SEARCH_URL = "/api/rules/search.protobuf?f=repo,name,severity,lang,internalKey,templateKey,params,actives,createdAt&activation=true";
    private final ScannerWsClient wsClient;

    public DefaultActiveRulesLoader(ScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public List<LoadedActiveRule> load(String qualityProfileKey) {
        LinkedList<LoadedActiveRule> ruleList = new LinkedList<LoadedActiveRule>();
        int page = 1;
        int pageSize = 500;
        int loaded = 0;
        while (true) {
            GetRequest getRequest = new GetRequest(DefaultActiveRulesLoader.getUrl(qualityProfileKey, page, pageSize));
            Rules.SearchResponse response = DefaultActiveRulesLoader.loadFromStream(this.wsClient.call((WsRequest)getRequest).contentStream());
            List<LoadedActiveRule> pageRules = DefaultActiveRulesLoader.readPage(response);
            ruleList.addAll(pageRules);
            loaded = (int)((long)loaded + response.getPs());
            if (response.getTotal() <= (long)loaded) break;
            ++page;
        }
        return ruleList;
    }

    private static String getUrl(String qualityProfileKey, int page, int pageSize) {
        StringBuilder builder = new StringBuilder(1024);
        builder.append(RULES_SEARCH_URL);
        builder.append("&qprofile=").append(ScannerUtils.encodeForUrl(qualityProfileKey));
        builder.append("&p=").append(page);
        builder.append("&ps=").append(pageSize);
        return builder.toString();
    }

    private static Rules.SearchResponse loadFromStream(InputStream is) {
        try {
            Rules.SearchResponse searchResponse = Rules.SearchResponse.parseFrom((InputStream)is);
            return searchResponse;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load quality profiles", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private static List<LoadedActiveRule> readPage(Rules.SearchResponse response) {
        LinkedList<LoadedActiveRule> loadedRules = new LinkedList<LoadedActiveRule>();
        List rulesList = response.getRulesList();
        Map actives = response.getActives().getActives();
        for (Rules.Rule r : rulesList) {
            Rules.ActiveList activeList = (Rules.ActiveList)actives.get(r.getKey());
            Rules.Active active = activeList.getActiveList(0);
            LoadedActiveRule loadedRule = new LoadedActiveRule();
            loadedRule.setRuleKey(RuleKey.parse((String)r.getKey()));
            loadedRule.setName(r.getName());
            loadedRule.setSeverity(active.getSeverity());
            loadedRule.setCreatedAt(DateUtils.dateToLong((Date)DateUtils.parseDateTime((String)active.getCreatedAt())));
            loadedRule.setLanguage(r.getLang());
            loadedRule.setInternalKey(r.getInternalKey());
            if (r.hasTemplateKey()) {
                RuleKey templateRuleKey = RuleKey.parse((String)r.getTemplateKey());
                loadedRule.setTemplateRuleKey(templateRuleKey.rule());
            }
            HashMap<String, String> params = new HashMap<String, String>();
            for (Rules.Rule.Param param : r.getParams().getParamsList()) {
                params.put(param.getKey(), param.getDefaultValue());
            }
            for (Rules.Rule.Param param : active.getParamsList()) {
                params.put(param.getKey(), param.getValue());
            }
            loadedRule.setParams(params);
            loadedRules.add(loadedRule);
        }
        return loadedRules;
    }
}

