/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.scanner.protocol.output.ScannerReport;

public class ScannerReportUtils {
    private ScannerReportUtils() {
    }

    public static ScannerReport.SyntaxHighlightingRule.HighlightingType toProtocolType(TypeOfText textType) {
        switch (textType) {
            case ANNOTATION: {
                return ScannerReport.SyntaxHighlightingRule.HighlightingType.ANNOTATION;
            }
            case COMMENT: {
                return ScannerReport.SyntaxHighlightingRule.HighlightingType.COMMENT;
            }
            case CONSTANT: {
                return ScannerReport.SyntaxHighlightingRule.HighlightingType.CONSTANT;
            }
            case CPP_DOC: {
                return ScannerReport.SyntaxHighlightingRule.HighlightingType.CPP_DOC;
            }
            case KEYWORD: {
                return ScannerReport.SyntaxHighlightingRule.HighlightingType.KEYWORD;
            }
            case KEYWORD_LIGHT: {
                return ScannerReport.SyntaxHighlightingRule.HighlightingType.KEYWORD_LIGHT;
            }
            case PREPROCESS_DIRECTIVE: {
                return ScannerReport.SyntaxHighlightingRule.HighlightingType.PREPROCESS_DIRECTIVE;
            }
            case STRING: {
                return ScannerReport.SyntaxHighlightingRule.HighlightingType.HIGHLIGHTING_STRING;
            }
            case STRUCTURED_COMMENT: {
                return ScannerReport.SyntaxHighlightingRule.HighlightingType.STRUCTURED_COMMENT;
            }
        }
        throw new IllegalArgumentException("Unknow highlighting type: " + textType);
    }

    public static TypeOfText toBatchType(ScannerReport.SyntaxHighlightingRule.HighlightingType type) {
        switch (type) {
            case ANNOTATION: {
                return TypeOfText.ANNOTATION;
            }
            case COMMENT: {
                return TypeOfText.COMMENT;
            }
            case CONSTANT: {
                return TypeOfText.CONSTANT;
            }
            case CPP_DOC: {
                return TypeOfText.CPP_DOC;
            }
            case HIGHLIGHTING_STRING: {
                return TypeOfText.STRING;
            }
            case KEYWORD: {
                return TypeOfText.KEYWORD;
            }
            case KEYWORD_LIGHT: {
                return TypeOfText.KEYWORD_LIGHT;
            }
            case PREPROCESS_DIRECTIVE: {
                return TypeOfText.PREPROCESS_DIRECTIVE;
            }
            case STRUCTURED_COMMENT: {
                return TypeOfText.STRUCTURED_COMMENT;
            }
        }
        throw new IllegalArgumentException(type + " is not a valid type");
    }

    public static String toCssClass(ScannerReport.SyntaxHighlightingRule.HighlightingType type) {
        return ScannerReportUtils.toBatchType(type).cssClass();
    }
}

