/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.test.TestCase;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.scanner.deprecated.test.DefaultTestPlan;
import org.sonar.scanner.deprecated.test.TestPlanBuilder;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scan.measure.MeasureCache;

public class MeasuresPublisher
implements ReportPublisherStep {
    private final InputComponentStore componentStore;
    private final MeasureCache measureCache;
    private final TestPlanBuilder testPlanBuilder;

    public MeasuresPublisher(InputComponentStore componentStore, MeasureCache measureCache, TestPlanBuilder testPlanBuilder) {
        this.componentStore = componentStore;
        this.measureCache = measureCache;
        this.testPlanBuilder = testPlanBuilder;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        ScannerReport.Measure.Builder builder = ScannerReport.Measure.newBuilder();
        for (InputComponent c : this.componentStore.all()) {
            Iterable<DefaultMeasure<?>> scannerMeasures;
            DefaultInputComponent component = (DefaultInputComponent)c;
            if (component.isFile()) {
                DefaultInputFile file = (DefaultInputFile)component;
                this.updateCoverageFromLineData((InputFile)file);
                this.updateTestExecutionFromTestPlan((InputFile)file);
            }
            if (!(scannerMeasures = this.measureCache.byComponentKey(component.key())).iterator().hasNext()) continue;
            writer.writeComponentMeasures(component.batchId(), (Iterable)StreamSupport.stream(scannerMeasures.spliterator(), false).map(input -> {
                if (input.value() == null) {
                    throw new IllegalArgumentException(String.format("Measure on metric '%s' and component '%s' has no value, but it's not allowed", input.metric().key(), component.key()));
                }
                builder.clear();
                builder.setMetricKey(input.metric().key());
                MeasuresPublisher.setValueAccordingToType(builder, input);
                return builder.build();
            }).collect(Collectors.toList()));
        }
    }

    private static void setValueAccordingToType(ScannerReport.Measure.Builder builder, DefaultMeasure<?> measure) {
        Serializable value = measure.value();
        Metric metric = measure.metric();
        if (Boolean.class.equals((Object)metric.valueType())) {
            builder.setBooleanValue(ScannerReport.Measure.BoolValue.newBuilder().setValue(((Boolean)value).booleanValue()));
        } else if (Integer.class.equals((Object)metric.valueType())) {
            builder.setIntValue(ScannerReport.Measure.IntValue.newBuilder().setValue(((Number)value).intValue()));
        } else if (Double.class.equals((Object)metric.valueType())) {
            builder.setDoubleValue(ScannerReport.Measure.DoubleValue.newBuilder().setValue(((Number)value).doubleValue()));
        } else if (String.class.equals((Object)metric.valueType())) {
            builder.setStringValue(ScannerReport.Measure.StringValue.newBuilder().setValue((String)((Object)value)));
        } else if (Long.class.equals((Object)metric.valueType())) {
            builder.setLongValue(ScannerReport.Measure.LongValue.newBuilder().setValue(((Number)value).longValue()));
        } else {
            throw new UnsupportedOperationException("Unsupported type :" + metric.valueType());
        }
    }

    private void updateTestExecutionFromTestPlan(InputFile inputFile) {
        DefaultTestPlan testPlan = this.testPlanBuilder.getTestPlanByFile(inputFile);
        if (testPlan == null || Iterables.isEmpty((Iterable)testPlan.testCases())) {
            return;
        }
        long nonSkippedTests = StreamSupport.stream(testPlan.testCases().spliterator(), false).filter(t -> t.status() != TestCase.Status.SKIPPED).count();
        this.measureCache.put(inputFile.key(), "tests", new DefaultMeasure().forMetric((Metric)CoreMetrics.TESTS).withValue((Serializable)Integer.valueOf((int)nonSkippedTests)));
        long executionTime = StreamSupport.stream(testPlan.testCases().spliterator(), false).mapToLong(t -> t.durationInMs() != null ? t.durationInMs() : 0L).sum();
        this.measureCache.put(inputFile.key(), "test_execution_time", new DefaultMeasure().forMetric((Metric)CoreMetrics.TEST_EXECUTION_TIME).withValue((Serializable)Long.valueOf(executionTime)));
        long errorTests = StreamSupport.stream(testPlan.testCases().spliterator(), false).filter(t -> t.status() == TestCase.Status.ERROR).count();
        this.measureCache.put(inputFile.key(), "test_errors", new DefaultMeasure().forMetric((Metric)CoreMetrics.TEST_ERRORS).withValue((Serializable)Integer.valueOf((int)errorTests)));
        long skippedTests = StreamSupport.stream(testPlan.testCases().spliterator(), false).filter(t -> t.status() == TestCase.Status.SKIPPED).count();
        this.measureCache.put(inputFile.key(), "skipped_tests", new DefaultMeasure().forMetric((Metric)CoreMetrics.SKIPPED_TESTS).withValue((Serializable)Integer.valueOf((int)skippedTests)));
        long failedTests = StreamSupport.stream(testPlan.testCases().spliterator(), false).filter(t -> t.status() == TestCase.Status.FAILURE).count();
        this.measureCache.put(inputFile.key(), "test_failures", new DefaultMeasure().forMetric((Metric)CoreMetrics.TEST_FAILURES).withValue((Serializable)Integer.valueOf((int)failedTests)));
    }

    private void updateCoverageFromLineData(InputFile inputFile) {
        if (inputFile.type() != InputFile.Type.MAIN) {
            return;
        }
        DefaultMeasure<?> lineHitsMeasure = this.measureCache.byMetric(inputFile.key(), "coverage_line_hits_data");
        if (lineHitsMeasure != null) {
            Map lineHits = KeyValueFormat.parseIntInt((String)((String)((Object)lineHitsMeasure.value())));
            this.measureCache.put(inputFile.key(), "lines_to_cover", new DefaultMeasure().forMetric((Metric)CoreMetrics.LINES_TO_COVER).withValue((Serializable)Integer.valueOf(lineHits.keySet().size())));
            this.measureCache.put(inputFile.key(), "uncovered_lines", new DefaultMeasure().forMetric((Metric)CoreMetrics.UNCOVERED_LINES).withValue((Serializable)Integer.valueOf((int)lineHits.values().stream().filter(hit -> hit == 0).count())));
        }
        DefaultMeasure<?> conditionsMeasure = this.measureCache.byMetric(inputFile.key(), "conditions_by_line");
        DefaultMeasure<?> coveredConditionsMeasure = this.measureCache.byMetric(inputFile.key(), "covered_conditions_by_line");
        if (conditionsMeasure != null) {
            Map conditions = KeyValueFormat.parseIntInt((String)((String)((Object)conditionsMeasure.value())));
            Map coveredConditions = coveredConditionsMeasure != null ? KeyValueFormat.parseIntInt((String)((String)((Object)coveredConditionsMeasure.value()))) : Collections.emptyMap();
            this.measureCache.put(inputFile.key(), "conditions_to_cover", new DefaultMeasure().forMetric((Metric)CoreMetrics.CONDITIONS_TO_COVER).withValue((Serializable)Integer.valueOf(conditions.values().stream().mapToInt(Integer::intValue).sum())));
            this.measureCache.put(inputFile.key(), "uncovered_conditions", new DefaultMeasure().forMetric((Metric)CoreMetrics.UNCOVERED_CONDITIONS).withValue((Serializable)Integer.valueOf(conditions.keySet().stream().mapToInt(line -> (Integer)conditions.get(line) - (Integer)coveredConditions.get(line)).sum())));
        }
    }
}

