/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.sonar.scanner.config.DefaultConfiguration;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.repository.ContextPropertiesCache;

public class ContextPropertiesPublisher
implements ReportPublisherStep {
    private final ContextPropertiesCache cache;
    private final DefaultConfiguration config;

    public ContextPropertiesPublisher(ContextPropertiesCache cache, DefaultConfiguration config) {
        this.cache = cache;
        this.config = config;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        MapEntryToContextPropertyFunction transformer = new MapEntryToContextPropertyFunction();
        Stream<ScannerReport.ContextProperty> fromCache = this.cache.getAll().entrySet().stream().map(transformer);
        Stream<ScannerReport.ContextProperty> fromSettings = this.config.getProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("sonar.analysis.")).map(transformer);
        writer.writeContextProperties((Iterable)Stream.concat(fromCache, fromSettings).collect(Collectors.toList()));
    }

    private static final class MapEntryToContextPropertyFunction
    implements Function<Map.Entry<String, String>, ScannerReport.ContextProperty> {
        private final ScannerReport.ContextProperty.Builder builder = ScannerReport.ContextProperty.newBuilder();

        private MapEntryToContextPropertyFunction() {
        }

        @Override
        public ScannerReport.ContextProperty apply(@Nonnull Map.Entry<String, String> input) {
            return this.builder.clear().setKey(input.getKey()).setValue(input.getValue()).build();
        }
    }
}

