/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputComponentTree;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportReader;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.branch.BranchConfiguration;

public class ComponentsPublisher
implements ReportPublisherStep {
    private final InputComponentTree componentTree;
    private final InputModuleHierarchy moduleHierarchy;
    private final BranchConfiguration branchConfiguration;
    private ScannerReportReader reader;
    private ScannerReportWriter writer;

    public ComponentsPublisher(InputModuleHierarchy moduleHierarchy, InputComponentTree inputComponentTree, BranchConfiguration branchConfiguration) {
        this.moduleHierarchy = moduleHierarchy;
        this.componentTree = inputComponentTree;
        this.branchConfiguration = branchConfiguration;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        this.reader = new ScannerReportReader(writer.getFileStructure().root());
        this.writer = writer;
        this.recursiveWriteComponent((DefaultInputComponent)this.moduleHierarchy.root());
    }

    private boolean recursiveWriteComponent(DefaultInputComponent component) {
        ScannerReport.Component.FileStatus status;
        Collection children = this.componentTree.getChildren((InputComponent)component).stream().filter(c -> this.recursiveWriteComponent((DefaultInputComponent)c)).collect(Collectors.toList());
        if (this.shouldSkipComponent(component, children)) {
            return false;
        }
        ScannerReport.Component.Builder builder = ScannerReport.Component.newBuilder();
        builder.setRef(component.batchId());
        builder.setType(this.getType((InputComponent)component));
        if (component instanceof InputModule) {
            String description;
            DefaultInputModule inputModule = (DefaultInputModule)component;
            builder.setKey(inputModule.key());
            String name = ComponentsPublisher.getName(inputModule);
            if (name != null) {
                builder.setName(name);
            }
            if ((description = ComponentsPublisher.getDescription(inputModule)) != null) {
                builder.setDescription(description);
            }
            this.writeVersion(inputModule, builder);
        } else if (component.isFile()) {
            DefaultInputFile file = (DefaultInputFile)component;
            builder.setIsTest(file.type() == InputFile.Type.TEST);
            builder.setLines(file.lines());
            builder.setStatus(this.convert(file.status()));
            String lang = ComponentsPublisher.getLanguageKey((InputFile)file);
            if (lang != null) {
                builder.setLanguage(lang);
            }
        } else if (component instanceof InputDir && (status = ComponentsPublisher.getDirectoryStatus((InputComponent)component, children)) != null) {
            builder.setStatus(status);
        }
        String path = this.getPath((InputComponent)component);
        if (path != null) {
            builder.setPath(path);
        }
        for (InputComponent child : children) {
            builder.addChildRef(((DefaultInputComponent)child).batchId());
        }
        ComponentsPublisher.writeLinks((InputComponent)component, builder);
        this.writer.writeComponent(builder.build());
        return true;
    }

    private ScannerReport.Component.FileStatus convert(InputFile.Status status) {
        switch (status) {
            case ADDED: {
                return ScannerReport.Component.FileStatus.ADDED;
            }
            case CHANGED: {
                return ScannerReport.Component.FileStatus.CHANGED;
            }
            case SAME: {
                return ScannerReport.Component.FileStatus.SAME;
            }
        }
        throw new IllegalArgumentException("Unexpected status: " + status);
    }

    @CheckForNull
    private static ScannerReport.Component.FileStatus getDirectoryStatus(InputComponent component, Collection<InputComponent> children) {
        if (children.isEmpty()) {
            return null;
        }
        boolean hasChangedFiles = children.stream().filter(c -> c instanceof InputFile).map(c -> (DefaultInputFile)c).anyMatch(f -> f.isPublished() && f.status() != InputFile.Status.SAME);
        if (!hasChangedFiles) {
            return ScannerReport.Component.FileStatus.SAME;
        }
        return null;
    }

    private boolean shouldSkipComponent(DefaultInputComponent component, Collection<InputComponent> children) {
        block18: {
            if (component instanceof InputModule && children.isEmpty() && this.branchConfiguration.isShortLivingBranch()) {
                return !this.moduleHierarchy.isRoot((InputModule)component);
            }
            if (component instanceof InputDir && children.isEmpty()) {
                try (CloseableIterator componentIssuesIt = this.reader.readComponentIssues(component.batchId());){
                    if (!componentIssuesIt.hasNext()) {
                        boolean bl = true;
                        return bl;
                    }
                    break block18;
                }
            }
            if (component instanceof DefaultInputFile) {
                DefaultInputFile inputFile = (DefaultInputFile)component;
                return !inputFile.isPublished() || this.branchConfiguration.isShortLivingBranch() && inputFile.status() == InputFile.Status.SAME;
            }
        }
        return false;
    }

    private void writeVersion(DefaultInputModule module, ScannerReport.Component.Builder builder) {
        String version = this.getVersion(module);
        if (version != null) {
            builder.setVersion(version);
        }
    }

    @CheckForNull
    private String getPath(InputComponent component) {
        if (component instanceof InputFile) {
            DefaultInputFile inputPath = (DefaultInputFile)component;
            return inputPath.getModuleRelativePath();
        }
        if (component instanceof InputDir) {
            InputDir inputPath = (InputDir)component;
            if (StringUtils.isEmpty((String)inputPath.relativePath())) {
                return "/";
            }
            return inputPath.relativePath();
        }
        if (component instanceof InputModule) {
            InputModule module = (InputModule)component;
            return this.moduleHierarchy.relativePath(module);
        }
        throw new IllegalStateException("Unkown component: " + component.getClass());
    }

    private String getVersion(DefaultInputModule module) {
        String version = module.getOriginalVersion();
        if (StringUtils.isNotBlank((String)version)) {
            return version;
        }
        DefaultInputModule parent = this.moduleHierarchy.parent((InputModule)module);
        return parent != null ? this.getVersion(parent) : null;
    }

    private static void writeLinks(InputComponent c, ScannerReport.Component.Builder builder) {
        if (c instanceof InputModule) {
            DefaultInputModule inputModule = (DefaultInputModule)c;
            ProjectDefinition def = inputModule.definition();
            ScannerReport.ComponentLink.Builder linkBuilder = ScannerReport.ComponentLink.newBuilder();
            ComponentsPublisher.writeProjectLink(builder, def, linkBuilder, "sonar.links.homepage", ScannerReport.ComponentLink.ComponentLinkType.HOME);
            ComponentsPublisher.writeProjectLink(builder, def, linkBuilder, "sonar.links.ci", ScannerReport.ComponentLink.ComponentLinkType.CI);
            ComponentsPublisher.writeProjectLink(builder, def, linkBuilder, "sonar.links.issue", ScannerReport.ComponentLink.ComponentLinkType.ISSUE);
            ComponentsPublisher.writeProjectLink(builder, def, linkBuilder, "sonar.links.scm", ScannerReport.ComponentLink.ComponentLinkType.SCM);
            ComponentsPublisher.writeProjectLink(builder, def, linkBuilder, "sonar.links.scm_dev", ScannerReport.ComponentLink.ComponentLinkType.SCM_DEV);
        }
    }

    private static void writeProjectLink(ScannerReport.Component.Builder componentBuilder, ProjectDefinition def, ScannerReport.ComponentLink.Builder linkBuilder, String linkProp, ScannerReport.ComponentLink.ComponentLinkType linkType) {
        String link = (String)def.properties().get(linkProp);
        if (StringUtils.isNotBlank((String)link)) {
            linkBuilder.setType(linkType);
            linkBuilder.setHref(link);
            componentBuilder.addLink(linkBuilder.build());
            linkBuilder.clear();
        }
    }

    @CheckForNull
    private static String getLanguageKey(InputFile file) {
        return file.language();
    }

    @CheckForNull
    private static String getName(DefaultInputModule module) {
        if (StringUtils.isNotEmpty((String)module.definition().getBranch())) {
            return module.definition().getName() + " " + module.definition().getBranch();
        }
        return module.definition().getOriginalName();
    }

    @CheckForNull
    private static String getDescription(DefaultInputModule module) {
        return module.definition().getDescription();
    }

    private ScannerReport.Component.ComponentType getType(InputComponent r) {
        if (r instanceof InputFile) {
            return ScannerReport.Component.ComponentType.FILE;
        }
        if (r instanceof InputDir) {
            return ScannerReport.Component.ComponentType.DIRECTORY;
        }
        if (r instanceof InputModule && this.moduleHierarchy.isRoot((InputModule)r)) {
            return ScannerReport.Component.ComponentType.PROJECT;
        }
        if (r instanceof InputModule) {
            return ScannerReport.Component.ComponentType.MODULE;
        }
        throw new IllegalArgumentException("Unknown resource type: " + r);
    }
}

