/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.profiling;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.events.InitializerExecutionHandler;
import org.sonar.api.batch.events.InitializersPhaseHandler;
import org.sonar.api.batch.events.PostJobExecutionHandler;
import org.sonar.api.batch.events.PostJobsPhaseHandler;
import org.sonar.api.batch.events.ProjectAnalysisHandler;
import org.sonar.api.batch.events.SensorExecutionHandler;
import org.sonar.api.batch.events.SensorsPhaseHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.TimeUtils;
import org.sonar.scanner.bootstrap.GlobalProperties;
import org.sonar.scanner.events.BatchStepHandler;
import org.sonar.scanner.profiling.AbstractTimeProfiling;
import org.sonar.scanner.profiling.ModuleProfiling;
import org.sonar.scanner.profiling.Phase;
import org.sonar.scanner.profiling.PhaseProfiling;
import org.sonar.scanner.util.ScannerUtils;

public class PhasesSumUpTimeProfiler
implements ProjectAnalysisHandler,
SensorExecutionHandler,
PostJobExecutionHandler,
SensorsPhaseHandler,
PostJobsPhaseHandler,
InitializersPhaseHandler,
InitializerExecutionHandler,
BatchStepHandler {
    static final Logger LOG = LoggerFactory.getLogger(PhasesSumUpTimeProfiler.class);
    private static final int TEXT_RIGHT_PAD = 60;
    private static final int TIME_LEFT_PAD = 10;
    @VisibleForTesting
    ModuleProfiling currentModuleProfiling;
    @VisibleForTesting
    ModuleProfiling totalProfiling;
    private Map<Project, ModuleProfiling> modulesProfilings = new HashMap<Project, ModuleProfiling>();
    private final System2 system;
    private final File out;

    public PhasesSumUpTimeProfiler(System2 system, GlobalProperties bootstrapProps) {
        String workingDirPath = StringUtils.defaultIfBlank((String)bootstrapProps.property("sonar.working.directory"), (String)".sonar");
        File workingDir = new File(workingDirPath).getAbsoluteFile();
        this.out = new File(workingDir, "profiling");
        this.out.mkdirs();
        this.totalProfiling = new ModuleProfiling(null, system);
        this.system = system;
    }

    static void println(String msg) {
        LOG.info(msg);
    }

    static void println(String text, @Nullable Double percent, AbstractTimeProfiling phaseProfiling) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.rightPad((String)text, (int)60)).append(StringUtils.leftPad((String)phaseProfiling.totalTimeAsString(), (int)10));
        if (percent != null) {
            sb.append(" (").append((int)((double)phaseProfiling.totalTime() / percent)).append("%)");
        }
        PhasesSumUpTimeProfiler.println(sb.toString());
    }

    public void onProjectAnalysis(ProjectAnalysisHandler.ProjectAnalysisEvent event) {
        Project module = event.getProject();
        if (event.isStart()) {
            this.currentModuleProfiling = new ModuleProfiling(module, this.system);
        } else {
            this.currentModuleProfiling.stop();
            this.modulesProfilings.put(module, this.currentModuleProfiling);
            long moduleTotalTime = this.currentModuleProfiling.totalTime();
            PhasesSumUpTimeProfiler.println("");
            PhasesSumUpTimeProfiler.println(" -------- Profiling of module " + module.getName() + ": " + TimeUtils.formatDuration((long)moduleTotalTime) + " --------");
            PhasesSumUpTimeProfiler.println("");
            Properties props = new Properties();
            this.currentModuleProfiling.dump(props);
            PhasesSumUpTimeProfiler.println("");
            PhasesSumUpTimeProfiler.println(" -------- End of profiling of module " + module.getName() + " --------");
            PhasesSumUpTimeProfiler.println("");
            String fileName = module.getKey() + "-profiler.properties";
            this.dumpToFile(props, ScannerUtils.cleanKeyForFilename(fileName));
            this.totalProfiling.merge(this.currentModuleProfiling);
            if (module.getParent() == null && !module.getModules().isEmpty()) {
                this.dumpTotalExecutionSummary();
            }
        }
    }

    private void dumpTotalExecutionSummary() {
        this.totalProfiling.stop();
        long totalTime = this.totalProfiling.totalTime();
        PhasesSumUpTimeProfiler.println("");
        PhasesSumUpTimeProfiler.println(" ======== Profiling of total execution: " + TimeUtils.formatDuration((long)totalTime) + " ========");
        PhasesSumUpTimeProfiler.println("");
        PhasesSumUpTimeProfiler.println(" * Module execution time breakdown: ");
        double percent = (double)totalTime / 100.0;
        for (ModuleProfiling modulesProfiling : AbstractTimeProfiling.truncate(AbstractTimeProfiling.sortByDescendingTotalTime(this.modulesProfilings).values())) {
            PhasesSumUpTimeProfiler.println("   o " + modulesProfiling.moduleName() + " execution time: ", percent, modulesProfiling);
        }
        PhasesSumUpTimeProfiler.println("");
        Properties props = new Properties();
        this.totalProfiling.dump(props);
        PhasesSumUpTimeProfiler.println("");
        PhasesSumUpTimeProfiler.println(" ======== End of profiling of total execution ========");
        PhasesSumUpTimeProfiler.println("");
        String fileName = "total-execution-profiler.properties";
        this.dumpToFile(props, fileName);
    }

    private void dumpToFile(Properties props, String fileName) {
        File file = new File(this.out, fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            props.store(fos, "SonarQube");
            PhasesSumUpTimeProfiler.println("Profiling data stored in " + file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to store profiler output: " + file, e);
        }
    }

    public void onSensorsPhase(SensorsPhaseHandler.SensorsPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phase.SENSOR);
        } else {
            this.currentModuleProfiling.getProfilingPerPhase(Phase.SENSOR).stop();
        }
    }

    public void onSensorExecution(SensorExecutionHandler.SensorExecutionEvent event) {
        PhaseProfiling profiling = this.currentModuleProfiling.getProfilingPerPhase(Phase.SENSOR);
        if (event.isStart()) {
            profiling.newItemProfiling(event.getSensor());
        } else {
            profiling.getProfilingPerItem(event.getSensor()).stop();
        }
    }

    public void onPostJobsPhase(PostJobsPhaseHandler.PostJobsPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phase.POSTJOB);
        } else {
            this.currentModuleProfiling.getProfilingPerPhase(Phase.POSTJOB).stop();
        }
    }

    public void onPostJobExecution(PostJobExecutionHandler.PostJobExecutionEvent event) {
        PhaseProfiling profiling = this.currentModuleProfiling.getProfilingPerPhase(Phase.POSTJOB);
        if (event.isStart()) {
            profiling.newItemProfiling(event.getPostJob());
        } else {
            profiling.getProfilingPerItem(event.getPostJob()).stop();
        }
    }

    public void onInitializersPhase(InitializersPhaseHandler.InitializersPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phase.INIT);
        } else {
            this.currentModuleProfiling.getProfilingPerPhase(Phase.INIT).stop();
        }
    }

    public void onInitializerExecution(InitializerExecutionHandler.InitializerExecutionEvent event) {
        PhaseProfiling profiling = this.currentModuleProfiling.getProfilingPerPhase(Phase.INIT);
        if (event.isStart()) {
            profiling.newItemProfiling(event.getInitializer());
        } else {
            profiling.getProfilingPerItem(event.getInitializer()).stop();
        }
    }

    @Override
    public void onBatchStep(BatchStepHandler.BatchStepEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addBatchStepProfiling(event.stepName());
        } else {
            this.currentModuleProfiling.getProfilingPerBatchStep(event.stepName()).stop();
        }
    }
}

