/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.postjob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.postjob.internal.DefaultPostJobDescriptor;
import org.sonar.api.config.Settings;

@ScannerSide
public class PostJobOptimizer {
    private static final Logger LOG = LoggerFactory.getLogger(PostJobOptimizer.class);
    private final Settings settings;

    public PostJobOptimizer(Settings settings) {
        this.settings = settings;
    }

    public boolean shouldExecute(DefaultPostJobDescriptor descriptor) {
        if (!this.settingsCondition(descriptor)) {
            LOG.debug("'{}' skipped because one of the required properties is missing", (Object)descriptor.name());
            return false;
        }
        return true;
    }

    private boolean settingsCondition(DefaultPostJobDescriptor descriptor) {
        if (!descriptor.properties().isEmpty()) {
            for (String propertyKey : descriptor.properties()) {
                if (this.settings.hasKey(propertyKey)) continue;
                return false;
            }
        }
        return true;
    }
}

