/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.phases;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.resources.Project;
import org.sonar.scanner.bootstrap.ScannerExtensionDictionnary;
import org.sonar.scanner.events.EventBus;
import org.sonar.scanner.phases.SensorExecutionEvent;
import org.sonar.scanner.phases.SensorsPhaseEvent;

@ScannerSide
public class SensorsExecutor {
    private final ScannerExtensionDictionnary selector;
    private final DefaultInputModule module;
    private final EventBus eventBus;
    private final SensorStrategy strategy;
    private final boolean isRoot;

    public SensorsExecutor(ScannerExtensionDictionnary selector, DefaultInputModule module, InputModuleHierarchy hierarchy, EventBus eventBus, SensorStrategy strategy) {
        this.selector = selector;
        this.module = module;
        this.eventBus = eventBus;
        this.strategy = strategy;
        this.isRoot = hierarchy.isRoot((InputModule)module);
    }

    public void execute(SensorContext context) {
        List<Sensor> globalSensors;
        Collection<Sensor> perModuleSensors = this.selector.selectSensors(this.module, false);
        if (this.isRoot) {
            boolean orig = this.strategy.isGlobal();
            this.strategy.setGlobal(true);
            globalSensors = this.selector.selectSensors(this.module, true);
            this.strategy.setGlobal(orig);
        } else {
            globalSensors = Collections.emptyList();
        }
        ArrayList<Sensor> allSensors = new ArrayList<Sensor>(perModuleSensors);
        allSensors.addAll(globalSensors);
        this.eventBus.fireEvent(new SensorsPhaseEvent(Lists.newArrayList(allSensors), true));
        this.execute(context, perModuleSensors);
        if (this.isRoot) {
            boolean orig = this.strategy.isGlobal();
            this.strategy.setGlobal(true);
            this.execute(context, globalSensors);
            this.strategy.setGlobal(orig);
        }
        this.eventBus.fireEvent(new SensorsPhaseEvent(Lists.newArrayList(allSensors), false));
    }

    private void execute(SensorContext context, Collection<Sensor> sensors) {
        for (Sensor sensor : sensors) {
            this.executeSensor(context, sensor);
        }
    }

    private void executeSensor(SensorContext context, Sensor sensor) {
        this.eventBus.fireEvent(new SensorExecutionEvent(sensor, true));
        sensor.analyse(new Project(this.module), context);
        this.eventBus.fireEvent(new SensorExecutionEvent(sensor, false));
    }
}

