/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.phases;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.Initializer;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.ScannerExtensionDictionnary;
import org.sonar.scanner.events.EventBus;
import org.sonar.scanner.phases.InitializerExecutionEvent;
import org.sonar.scanner.phases.InitializersPhaseEvent;
import org.sonar.scanner.phases.SensorsExecutor;

public class InitializersExecutor {
    private static final Logger LOG = Loggers.get(SensorsExecutor.class);
    private final DefaultInputModule module;
    private final ScannerExtensionDictionnary selector;
    private final EventBus eventBus;

    public InitializersExecutor(ScannerExtensionDictionnary selector, DefaultInputModule module, EventBus eventBus) {
        this.selector = selector;
        this.module = module;
        this.eventBus = eventBus;
    }

    public void execute() {
        Collection<Initializer> initializers = this.selector.select(Initializer.class, this.module, true, null);
        this.eventBus.fireEvent(new InitializersPhaseEvent(Lists.newArrayList(initializers), true));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializers : {}", (Object)StringUtils.join(initializers, (String)" -> "));
        }
        Project project = new Project(this.module);
        for (Initializer initializer : initializers) {
            this.eventBus.fireEvent(new InitializerExecutionEvent(initializer, true));
            Profiler profiler = Profiler.create((Logger)LOG).startInfo("Initializer " + initializer);
            initializer.execute(project);
            profiler.stopInfo();
            this.eventBus.fireEvent(new InitializerExecutionEvent(initializer, false));
        }
        this.eventBus.fireEvent(new InitializersPhaseEvent(Lists.newArrayList(initializers), false));
    }
}

