/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.internal.charhandler.CharHandler;
import org.sonar.scanner.issue.ignore.pattern.BlockIssuePattern;
import org.sonar.scanner.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonar.scanner.issue.ignore.pattern.IssuePattern;
import org.sonar.scanner.issue.ignore.pattern.PatternMatcher;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsRegexpScanner;

public final class IssueExclusionsLoader {
    private final List<Pattern> allFilePatterns;
    private final List<DoubleRegexpMatcher> blockMatchers;
    private final PatternMatcher patternMatcher;
    private final IssueExclusionPatternInitializer patternsInitializer;
    private final boolean enableCharHandler;

    public IssueExclusionsLoader(IssueExclusionPatternInitializer patternsInitializer, PatternMatcher patternMatcher) {
        this.patternsInitializer = patternsInitializer;
        this.patternMatcher = patternMatcher;
        this.allFilePatterns = new ArrayList<Pattern>();
        this.blockMatchers = new ArrayList<DoubleRegexpMatcher>();
        for (String string : patternsInitializer.getAllFilePatterns()) {
            this.allFilePatterns.add(Pattern.compile(string));
        }
        for (BlockIssuePattern blockIssuePattern : patternsInitializer.getBlockPatterns()) {
            this.blockMatchers.add(new DoubleRegexpMatcher(Pattern.compile(blockIssuePattern.getBeginBlockRegexp()), Pattern.compile(blockIssuePattern.getEndBlockRegexp())));
        }
        this.enableCharHandler = !this.allFilePatterns.isEmpty() || !this.blockMatchers.isEmpty();
    }

    public boolean shouldExecute() {
        return this.patternsInitializer.hasMulticriteriaPatterns();
    }

    public void addMulticriteriaPatterns(String relativePath, String componentKey) {
        for (IssuePattern pattern : this.patternsInitializer.getMulticriteriaPatterns()) {
            if (!pattern.matchResource(relativePath)) continue;
            this.patternMatcher.addPatternForComponent(componentKey, pattern);
        }
    }

    @CheckForNull
    public CharHandler createCharHandlerFor(String componentKey) {
        if (this.enableCharHandler) {
            return new IssueExclusionsRegexpScanner(componentKey, this.allFilePatterns, this.blockMatchers, this.patternMatcher);
        }
        return null;
    }

    public String toString() {
        return "Issues Exclusions - Source Scanner";
    }

    public static class DoubleRegexpMatcher {
        private Pattern firstPattern;
        private Pattern secondPattern;

        DoubleRegexpMatcher(Pattern firstPattern, Pattern secondPattern) {
            this.firstPattern = firstPattern;
            this.secondPattern = secondPattern;
        }

        boolean matchesFirstPattern(String line) {
            return this.firstPattern.matcher(line).find();
        }

        boolean matchesSecondPattern(String line) {
            return this.hasSecondPattern() && this.secondPattern.matcher(line).find();
        }

        boolean hasSecondPattern() {
            return StringUtils.isNotEmpty((String)this.secondPattern.toString());
        }
    }
}

