/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.pattern;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.scanner.issue.ignore.pattern.LineRange;

@Immutable
public class IssuePattern {
    private final WildcardPattern resourcePattern;
    private final WildcardPattern rulePattern;
    private final Set<Integer> lines;
    private final Set<LineRange> lineRanges;
    private final boolean checkLines;

    public IssuePattern(String resourcePattern, String rulePattern) {
        this(resourcePattern, rulePattern, Collections.emptySet());
    }

    public IssuePattern(String resourcePattern, String rulePattern, Set<LineRange> lineRanges) {
        this.resourcePattern = WildcardPattern.create((String)resourcePattern);
        this.rulePattern = WildcardPattern.create((String)rulePattern);
        this.checkLines = !lineRanges.isEmpty();
        LinkedHashSet<Integer> modifiableLines = new LinkedHashSet<Integer>();
        LinkedHashSet<LineRange> modifiableLineRanges = new LinkedHashSet<LineRange>();
        for (LineRange range : lineRanges) {
            if (range.from() == range.to()) {
                modifiableLines.add(range.from());
                continue;
            }
            modifiableLineRanges.add(range);
        }
        this.lines = Collections.unmodifiableSet(modifiableLines);
        this.lineRanges = Collections.unmodifiableSet(modifiableLineRanges);
    }

    public WildcardPattern getResourcePattern() {
        return this.resourcePattern;
    }

    public WildcardPattern getRulePattern() {
        return this.rulePattern;
    }

    boolean isCheckLines() {
        return this.checkLines;
    }

    Set<Integer> getAllLines() {
        LinkedHashSet<Integer> allLines = new LinkedHashSet<Integer>(this.lines);
        for (LineRange lineRange : this.lineRanges) {
            allLines.addAll(lineRange.toLines());
        }
        return allLines;
    }

    public boolean match(@Nullable String componentKey, RuleKey ruleKey, @Nullable Integer line) {
        if (this.checkLines) {
            if (line == null) {
                return false;
            }
            return this.matchResource(componentKey) && this.matchRule(ruleKey) && this.matchLine(line);
        }
        return this.matchResource(componentKey) && this.matchRule(ruleKey);
    }

    boolean matchLine(int lineId) {
        if (this.lines.contains(lineId)) {
            return true;
        }
        for (LineRange range : this.lineRanges) {
            if (!range.in(lineId)) continue;
            return true;
        }
        return false;
    }

    boolean matchRule(RuleKey rule) {
        String key = rule.repository() + ':' + rule.rule();
        return this.rulePattern.match(key);
    }

    public boolean matchResource(@Nullable String resource) {
        return resource != null && this.resourcePattern.match(resource);
    }

    public IssuePattern forResource(String resource) {
        return new IssuePattern(resource, this.rulePattern.toString(), this.lineRanges);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

