/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cpd.deprecated;

import com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.scanner.cpd.deprecated.CpdBlockIndexer;
import org.sonar.scanner.cpd.deprecated.DefaultCpdBlockIndexer;
import org.sonar.scanner.cpd.deprecated.JavaCpdBlockIndexer;

@Phase(name=Phase.Name.POST)
public class DeprecatedCpdBlockIndexerSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(DeprecatedCpdBlockIndexerSensor.class);
    private CpdBlockIndexer javaCpdBlockIndexer;
    private CpdBlockIndexer defaultCpdBlockIndexer;
    private FileSystem fs;

    public DeprecatedCpdBlockIndexerSensor(JavaCpdBlockIndexer javaCpdBlockIndexer, DefaultCpdBlockIndexer defaultCpdBlockIndexer, FileSystem fs) {
        this.javaCpdBlockIndexer = javaCpdBlockIndexer;
        this.defaultCpdBlockIndexer = defaultCpdBlockIndexer;
        this.fs = fs;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("CPD Block Indexer").global();
    }

    @VisibleForTesting
    CpdBlockIndexer getBlockIndexer(String language) {
        if (this.javaCpdBlockIndexer.isLanguageSupported(language)) {
            return this.javaCpdBlockIndexer;
        }
        return this.defaultCpdBlockIndexer;
    }

    public void execute(SensorContext context) {
        for (String language : this.fs.languages()) {
            CpdBlockIndexer blockIndexer = this.getBlockIndexer(language);
            if (!blockIndexer.isLanguageSupported(language)) {
                LOG.debug("Detection of duplicated code is not supported for {}", (Object)language);
                continue;
            }
            LOG.debug("{} is used for {}", (Object)blockIndexer.getClass().getName(), (Object)language);
            blockIndexer.index(language);
        }
    }
}

