/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.function.Predicate;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.utils.ZipUtils;
import org.sonar.core.platform.ExplodedPlugin;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginJarExploder;
import org.sonar.core.util.FileUtils;
import org.sonar.home.cache.FileCache;

@ScannerSide
public class ScannerPluginJarExploder
extends PluginJarExploder {
    private final FileCache fileCache;

    public ScannerPluginJarExploder(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    public ExplodedPlugin explode(PluginInfo info) {
        try {
            File dir = this.unzipFile(info.getNonNullJarFile());
            return this.explodeFromUnzippedDir(info.getKey(), info.getNonNullJarFile(), dir);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to open plugin [%s]: %s", info.getKey(), info.getNonNullJarFile().getAbsolutePath()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File unzipFile(File cachedFile) throws IOException {
        String filename = cachedFile.getName();
        File destDir = new File(cachedFile.getParentFile(), filename + "_unzip");
        File lockFile = new File(cachedFile.getParentFile(), filename + "_unzip.lock");
        if (!destDir.exists()) {
            FileOutputStream out = new FileOutputStream(lockFile);
            try {
                FileLock lock = out.getChannel().lock();
                try {
                    if (!destDir.exists()) {
                        File tempDir = this.fileCache.createTempDir();
                        ZipUtils.unzip((File)cachedFile, (File)tempDir, (Predicate)this.newLibFilter());
                        org.apache.commons.io.FileUtils.moveDirectory((File)tempDir, (File)destDir);
                    }
                }
                finally {
                    lock.release();
                }
            }
            finally {
                out.close();
                FileUtils.deleteQuietly((File)lockFile);
            }
        }
        return destDir;
    }
}

