/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.platform.PluginInfo;
import org.sonar.home.cache.FileCache;
import org.sonar.scanner.bootstrap.PluginInstaller;
import org.sonar.scanner.bootstrap.ScannerPlugin;
import org.sonar.scanner.bootstrap.ScannerPluginPredicate;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;

public class ScannerPluginInstaller
implements PluginInstaller {
    private static final Logger LOG = Loggers.get(ScannerPluginInstaller.class);
    private static final String PLUGINS_WS_URL = "/api/plugins/installed";
    private final FileCache fileCache;
    private final ScannerPluginPredicate pluginPredicate;
    private final ScannerWsClient wsClient;

    public ScannerPluginInstaller(ScannerWsClient wsClient, FileCache fileCache, ScannerPluginPredicate pluginPredicate) {
        this.fileCache = fileCache;
        this.pluginPredicate = pluginPredicate;
        this.wsClient = wsClient;
    }

    @Override
    public Map<String, ScannerPlugin> installRemotes() {
        return this.loadPlugins(this.listInstalledPlugins());
    }

    private Map<String, ScannerPlugin> loadPlugins(InstalledPlugin[] remotePlugins) {
        HashMap<String, ScannerPlugin> infosByKey = new HashMap<String, ScannerPlugin>(remotePlugins.length);
        Profiler profiler = Profiler.create((Logger)LOG).startDebug("Load plugins");
        for (InstalledPlugin installedPlugin : remotePlugins) {
            if (!this.pluginPredicate.apply(installedPlugin.key)) continue;
            File jarFile = this.download(installedPlugin);
            PluginInfo info = PluginInfo.create((File)jarFile);
            infosByKey.put(info.getKey(), new ScannerPlugin(installedPlugin.key, installedPlugin.updatedAt, info));
        }
        profiler.stopDebug();
        return infosByKey;
    }

    @Override
    public List<Object[]> installLocals() {
        return Collections.emptyList();
    }

    @VisibleForTesting
    File download(InstalledPlugin remote) {
        try {
            return this.fileCache.get(remote.filename, remote.hash, (FileCache.Downloader)new FileDownloader(remote.key));
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to download plugin: " + remote.key, e);
        }
    }

    @VisibleForTesting
    InstalledPlugin[] listInstalledPlugins() {
        InstalledPlugins installedPlugins;
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Load plugins index");
        GetRequest getRequest = new GetRequest(PLUGINS_WS_URL);
        try (Reader reader = this.wsClient.call((WsRequest)getRequest).contentReader();){
            installedPlugins = (InstalledPlugins)new Gson().fromJson(reader, InstalledPlugins.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        profiler.stopInfo();
        return installedPlugins.plugins;
    }

    private class FileDownloader
    implements FileCache.Downloader {
        private String key;

        FileDownloader(String key) {
            this.key = key;
        }

        public void download(String filename, File toFile) throws IOException {
            String url = String.format("/deploy/plugins/%s/%s", this.key, filename);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Download plugin {} to {}", (Object)filename, (Object)toFile);
            } else {
                LOG.info("Download {}", (Object)filename);
            }
            WsResponse response = ScannerPluginInstaller.this.wsClient.call((WsRequest)new GetRequest(url));
            try (InputStream stream = response.contentStream();){
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)toFile);
            }
        }
    }

    static class InstalledPlugin {
        String key;
        String hash;
        String filename;
        long updatedAt;

        InstalledPlugin() {
        }
    }

    private static class InstalledPlugins {
        InstalledPlugin[] plugins;

        private InstalledPlugins() {
        }
    }
}

