/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner;

import java.time.Clock;
import java.util.Date;
import java.util.Optional;
import org.picocontainer.Startable;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.DateUtils;

@ScannerSide
public class ProjectAnalysisInfo
implements Startable {
    private final Clock clock;
    private Configuration settings;
    private Date analysisDate;
    private String analysisVersion;

    public ProjectAnalysisInfo(Configuration settings, Clock clock) {
        this.settings = settings;
        this.clock = clock;
    }

    public Date analysisDate() {
        return this.analysisDate;
    }

    public String analysisVersion() {
        return this.analysisVersion;
    }

    private Date loadAnalysisDate() {
        Optional value = this.settings.get("sonar.projectDate");
        if (!value.isPresent()) {
            return Date.from(this.clock.instant());
        }
        try {
            return DateUtils.parseDateTime((String)((String)value.get()));
        }
        catch (RuntimeException runtimeException) {
            try {
                return DateUtils.parseDate((String)((String)value.get()));
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Illegal value for 'sonar.projectDate'", e);
            }
        }
    }

    private String loadAnalysisVersion() {
        return this.settings.get("sonar.projectVersion").orElse(null);
    }

    public void start() {
        this.analysisDate = this.loadAnalysisDate();
        this.analysisVersion = this.loadAnalysisVersion();
    }

    public void stop() {
    }
}

